/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.token.support.core.configuration.IssuerConfiguration;
import no.nav.security.token.support.core.configuration.MultiIssuerConfiguration;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.exceptions.IssuerConfigurationException;
import no.nav.security.token.support.core.exceptions.JwtTokenValidatorException;
import no.nav.security.token.support.core.http.HttpRequest;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.validation.JwtTokenRetriever;
import no.nav.security.token.support.core.validation.JwtTokenValidator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenValidationHandler;", "", "config", "Lno/nav/security/token/support/core/configuration/MultiIssuerConfiguration;", "(Lno/nav/security/token/support/core/configuration/MultiIssuerConfiguration;)V", "getValidatedTokens", "Lno/nav/security/token/support/core/context/TokenValidationContext;", "request", "Lno/nav/security/token/support/core/http/HttpRequest;", "issuerConfiguration", "Lno/nav/security/token/support/core/configuration/IssuerConfiguration;", "issuer", "", "tokenValidator", "Lno/nav/security/token/support/core/validation/JwtTokenValidator;", "jwtToken", "Lno/nav/security/token/support/core/jwt/JwtToken;", "validate", "", "Companion", "token-validation-core"})
@SourceDebugExtension(value={"SMAP\nJwtTokenValidationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenValidationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenValidationHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1603#2,9:54\n1855#2:63\n1856#2:65\n1612#2:66\n1238#2,4:67\n1549#2:71\n1620#2,3:72\n1#3:64\n1#3:75\n*S KotlinDebug\n*F\n+ 1 JwtTokenValidationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenValidationHandler\n*L\n20#1:54,9\n20#1:63\n20#1:65\n20#1:66\n21#1:67,4\n24#1:71\n24#1:72,3\n20#1:64\n*E\n"})
public final class JwtTokenValidationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiIssuerConfiguration config;
    @NotNull
    private static final Logger LOG;

    public JwtTokenValidationHandler(@NotNull MultiIssuerConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TokenValidationContext getValidatedTokens(@NotNull HttpRequest request) {
        void $this$associateByTo$iv;
        JwtToken it$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List<JwtToken> $this$getValidatedTokens_u24lambda_u244 = JwtTokenRetriever.retrieveUnvalidatedTokens(this.config, request);
        boolean bl = false;
        Iterable $this$mapNotNull$iv = $this$getValidatedTokens_u24lambda_u244;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Map.Entry $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            JwtToken p0 = (JwtToken)element$iv$iv;
            boolean bl3 = false;
            if (this.validate(p0) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Map destination$iv = new ConcurrentHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            $this$forEach$iv$iv$iv = (Map.Entry)element$iv;
            Map map = destination$iv;
            boolean bl5 = false;
            Map.Entry it = (Map.Entry)element$iv;
            String string = (String)it.getKey();
            boolean bl6 = false;
            JwtToken jwtToken = (JwtToken)it.getValue();
            map.put(string, jwtToken);
        }
        ConcurrentHashMap $this$getValidatedTokens_u24lambda_u244_u24lambda_u243 = (ConcurrentHashMap)destination$iv;
        boolean bl7 = false;
        LOG.debug("Found {} tokens on request, number of validated tokens is {}", (Object)$this$getValidatedTokens_u24lambda_u244_u24lambda_u243.size(), (Object)$this$getValidatedTokens_u24lambda_u244_u24lambda_u243.size());
        if ($this$getValidatedTokens_u24lambda_u244_u24lambda_u243.isEmpty() && !((Map)$this$getValidatedTokens_u24lambda_u244_u24lambda_u243).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            destination$iv$iv = $this$getValidatedTokens_u24lambda_u244;
            Integer n = $this$getValidatedTokens_u24lambda_u244_u24lambda_u243.size();
            String string = "Found {} unvalidated token(s) with issuer(s) {} on request, is this a configuration error?";
            Logger logger = LOG;
            boolean $i$f$map = false;
            element$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                it$iv$iv = (JwtToken)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl8 = false;
                collection.add(p0.getIssuer());
            }
            List list = (List)destination$iv$iv2;
            logger.debug(string, (Object)n, (Object)list);
        }
        return new TokenValidationContext($this$getValidatedTokens_u24lambda_u244_u24lambda_u243);
    }

    private final Map.Entry<String, JwtToken> validate(JwtToken jwtToken) {
        AbstractMap.SimpleImmutableEntry<String, JwtToken> simpleImmutableEntry;
        JwtToken $this$validate_u24lambda_u248 = jwtToken;
        boolean bl = false;
        try {
            AbstractMap.SimpleImmutableEntry<String, JwtToken> simpleImmutableEntry2;
            LOG.debug("Check if token with issuer={} is present in config", (Object)$this$validate_u24lambda_u248.getIssuer());
            IssuerConfiguration issuerConfiguration = this.config.getIssuers().get($this$validate_u24lambda_u248.getIssuer());
            if (issuerConfiguration != null) {
                it = issuerConfiguration;
                boolean bl2 = false;
                String string = $this$validate_u24lambda_u248.getIssuer();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-issuer>(...)");
                String issuerShortName = this.issuerConfiguration(string).getName();
                LOG.debug("Found token from trusted issuer={} with shortName={} in request", (Object)$this$validate_u24lambda_u248.getIssuer(), (Object)issuerShortName);
                this.tokenValidator(jwtToken).assertValidToken($this$validate_u24lambda_u248.getEncodedToken());
                LOG.debug("Validated token from issuer[{}]", (Object)$this$validate_u24lambda_u248.getIssuer());
                simpleImmutableEntry2 = new AbstractMap.SimpleImmutableEntry<String, JwtToken>(issuerShortName, $this$validate_u24lambda_u248);
            } else {
                AbstractMap.SimpleImmutableEntry<String, JwtToken> simpleImmutableEntry3 = null;
                it = simpleImmutableEntry3;
                boolean bl3 = false;
                LOG.debug("Found token from unknown issuer[{}], skipping validation.", (Object)$this$validate_u24lambda_u248.getIssuer());
                simpleImmutableEntry2 = simpleImmutableEntry3;
            }
            simpleImmutableEntry = simpleImmutableEntry2;
        }
        catch (JwtTokenValidatorException e) {
            AbstractMap.SimpleImmutableEntry<String, JwtToken> simpleImmutableEntry4;
            AbstractMap.SimpleImmutableEntry<String, JwtToken> it = simpleImmutableEntry4 = null;
            boolean bl4 = false;
            Object[] objectArray = new Object[]{$this$validate_u24lambda_u248.getIssuer(), e.getExpiryDate(), e.getMessage()};
            LOG.info("Found invalid token for issuer [{}, expires at {}], message:{} ", objectArray);
            simpleImmutableEntry = simpleImmutableEntry4;
        }
        return simpleImmutableEntry;
    }

    private final JwtTokenValidator tokenValidator(JwtToken jwtToken) {
        String string = jwtToken.getIssuer();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-issuer>(...)");
        return this.issuerConfiguration(string).getTokenValidator();
    }

    private final IssuerConfiguration issuerConfiguration(String issuer) {
        IssuerConfiguration issuerConfiguration = this.config.getIssuers().get(issuer);
        if (issuerConfiguration == null) {
            throw new IssuerConfigurationException("Could not find IssuerConfiguration for issuer " + issuer, null, 2, null);
        }
        return issuerConfiguration;
    }

    static {
        Logger logger = LoggerFactory.getLogger(JwtTokenValidationHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenValidationHandler$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "token-validation-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

