/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.validation.DefaultConfigurableJwtValidator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0012"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenValidatorFactory;", "", "()V", "jwkSource", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "kotlin.jvm.PlatformType", "p", "Lno/nav/security/token/support/core/configuration/IssuerProperties;", "jwksUrl", "Ljava/net/URL;", "retriever", "Lcom/nimbusds/jose/util/ResourceRetriever;", "tokenValidator", "Lno/nav/security/token/support/core/validation/DefaultConfigurableJwtValidator;", "md", "Lcom/nimbusds/oauth2/sdk/as/AuthorizationServerMetadata;", "remoteJWKSet", "token-validation-core"})
public final class JwtTokenValidatorFactory {
    @NotNull
    public static final JwtTokenValidatorFactory INSTANCE = new JwtTokenValidatorFactory();

    private JwtTokenValidatorFactory() {
    }

    @JvmStatic
    @NotNull
    public static final DefaultConfigurableJwtValidator tokenValidator(@NotNull IssuerProperties p, @NotNull AuthorizationServerMetadata md, @NotNull ResourceRetriever retriever) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)retriever, (String)"retriever");
        URL uRL = md.getJWKSetURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        JWKSource<SecurityContext> jWKSource = INSTANCE.jwkSource(p, uRL, retriever);
        Intrinsics.checkNotNullExpressionValue(jWKSource, (String)"jwkSource(...)");
        return JwtTokenValidatorFactory.tokenValidator(p, md, jWKSource);
    }

    @JvmStatic
    @NotNull
    public static final DefaultConfigurableJwtValidator tokenValidator(@NotNull IssuerProperties p, @NotNull AuthorizationServerMetadata md, @NotNull JWKSource<SecurityContext> remoteJWKSet) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter(remoteJWKSet, (String)"remoteJWKSet");
        String string = md.getIssuer().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return new DefaultConfigurableJwtValidator(string, p.getAcceptedAudience(), p.getValidation().getOptionalClaims(), remoteJWKSet);
    }

    private final JWKSource<SecurityContext> jwkSource(IssuerProperties p, URL jwksUrl, ResourceRetriever retriever) {
        JWKSourceBuilder jWKSourceBuilder;
        JWKSourceBuilder $this$jwkSource_u24lambda_u240 = jWKSourceBuilder = JWKSourceBuilder.create((URL)jwksUrl, (ResourceRetriever)retriever);
        boolean bl = false;
        if (p.getJwksCache().isConfigured()) {
            $this$jwkSource_u24lambda_u240.cache(p.getJwksCache().getLifespanMillis(), p.getJwksCache().getRefreshTimeMillis());
        }
        return jWKSourceBuilder.build();
    }
}

