/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.jaxrs;

import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.exceptions.JwtTokenInvalidClaimException;
import no.nav.security.token.support.core.validation.JwtTokenAnnotationHandler;
import no.nav.security.token.support.jaxrs.JaxrsTokenValidationContextHolder;
import org.jetbrains.annotations.NotNull;

@Provider
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lno/nav/security/token/support/jaxrs/JwtTokenContainerRequestFilter;", "Ljakarta/ws/rs/container/ContainerRequestFilter;", "()V", "jwtTokenAnnotationHandler", "Lno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler;", "resourceInfo", "Ljakarta/ws/rs/container/ResourceInfo;", "filter", "", "containerRequestContext", "Ljakarta/ws/rs/container/ContainerRequestContext;", "token-validation-jaxrs"})
public final class JwtTokenContainerRequestFilter
implements ContainerRequestFilter {
    @NotNull
    private final JwtTokenAnnotationHandler jwtTokenAnnotationHandler = new JwtTokenAnnotationHandler(JaxrsTokenValidationContextHolder.INSTANCE.getHolder());
    @Context
    private ResourceInfo resourceInfo;

    @Inject
    public JwtTokenContainerRequestFilter() {
    }

    public void filter(@NotNull ContainerRequestContext containerRequestContext) {
        Intrinsics.checkNotNullParameter((Object)containerRequestContext, (String)"containerRequestContext");
        ResourceInfo resourceInfo = this.resourceInfo;
        if (resourceInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceInfo");
            resourceInfo = null;
        }
        Method method = resourceInfo.getResourceMethod();
        try {
            Intrinsics.checkNotNull((Object)method);
            this.jwtTokenAnnotationHandler.assertValidAnnotation(method);
        }
        catch (JwtTokenInvalidClaimException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.UNAUTHORIZED);
        }
    }
}

