/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Callback;
import kotlin.reflect.KFunction;

public class ReflectionHelper {

    public static class TreeTableCellValueFunctionRefCallback<S, T>
    implements Callback<TreeTableColumn.CellDataFeatures<S, T>, ObservableValue<T>> {
        private final KFunction<ObservableValue<T>> observableFn;
        private Method method;

        public TreeTableCellValueFunctionRefCallback(KFunction<ObservableValue<T>> observableFn) {
            this.observableFn = observableFn;
        }

        public ObservableValue<T> call(TreeTableColumn.CellDataFeatures<S, T> param) {
            if (param.getValue() == null) {
                return null;
            }
            Object item = param.getValue().getValue();
            if (item == null) {
                return null;
            }
            if (this.method == null) {
                try {
                    this.method = item.getClass().getDeclaredMethod(this.observableFn.getName(), new Class[0]);
                    if (!this.method.isAccessible()) {
                        this.method.setAccessible(true);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to extract observable function method");
                }
            }
            try {
                return (ObservableValue)this.method.invoke(item, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Unable to extract observable value");
            }
        }
    }

    public static class TableCellValueFunctionRefCallback<S, T>
    implements Callback<TableColumn.CellDataFeatures<S, T>, ObservableValue<T>> {
        private final KFunction<ObservableValue<T>> observableFn;
        private Method method;

        public TableCellValueFunctionRefCallback(KFunction<ObservableValue<T>> observableFn) {
            this.observableFn = observableFn;
        }

        public ObservableValue<T> call(TableColumn.CellDataFeatures<S, T> param) {
            Object item = param.getValue();
            if (item == null) {
                return null;
            }
            if (this.method == null) {
                try {
                    this.method = item.getClass().getDeclaredMethod(this.observableFn.getName(), new Class[0]);
                    if (!this.method.isAccessible()) {
                        this.method.setAccessible(true);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to extract observable function method");
                }
            }
            try {
                return (ObservableValue)this.method.invoke(item, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Unable to extract observable value");
            }
        }
    }
}

