/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.maven.plugin.erb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run", requiresProject=false)
public class ErbMojo
extends AbstractMojo {
    private static String rbInit = "require 'erb'\nrequire 'ostruct'\nrequire 'java'\n\ndef render(template, variables)\n  context = OpenStruct.new(variables).instance_eval do\n    variables.each do |k, v|\n      instance_variable_set(k, v) if k[0] == '@'\n    end\n    binding\n  end\n  ERB.new(template.to_io.read).result(context);\nend\n";
    @Parameter(name="templateFile", required=true)
    private File templateFile;
    @Parameter(name="propertiesFile", required=false)
    private File propertiesFile;
    @Parameter(name="properties", required=false)
    private Map<String, String> properties;
    @Parameter(name="outputFile", required=false)
    private File outputFile;
    private InputStream templateInputStream;
    private OutputStream resultOutputStream;
    private ScriptEngine jruby;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashMap<String, Object> rbVariables = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> e : this.properties().entrySet()) {
            rbVariables.put("@" + e.getKey(), e.getValue());
        }
        try {
            String result = this.jruby().invokeFunction("render", this.templateInputStream(), rbVariables).toString();
            OutputStream outputStream = this.resultOutputStream();
            outputStream.write(result.getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private Invocable jruby() {
        if (this.jruby == null) {
            this.jruby = new ScriptEngineManager().getEngineByName("jruby");
            try {
                this.jruby.eval(rbInit);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        }
        return (Invocable)((Object)this.jruby);
    }

    private InputStream templateInputStream() {
        if (this.templateInputStream != null) {
            return this.templateInputStream;
        }
        try {
            this.templateInputStream = new FileInputStream(this.templateFile);
            return this.templateInputStream;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Properties properties() {
        Properties answer = new Properties();
        if (this.propertiesFile != null) {
            try {
                answer.load(new FileInputStream(this.propertiesFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.properties != null) {
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                answer.put(e.getKey(), e.getValue());
            }
        }
        return answer;
    }

    private OutputStream resultOutputStream() {
        if (this.resultOutputStream != null) {
            return this.resultOutputStream;
        }
        try {
            this.resultOutputStream = new FileOutputStream(this.outputFile);
            return this.resultOutputStream;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    Map<String, String> getProperties() {
        return this.properties;
    }

    void setProperties(Map<String, String> props) {
        this.properties = props;
    }

    public InputStream getTemplateInputStream() {
        return this.templateInputStream;
    }

    void setTemplateInputStream(InputStream testTemplateInputStream) {
        this.templateInputStream = testTemplateInputStream;
    }

    public OutputStream getResultOutputStream() {
        return this.resultOutputStream;
    }

    void setResultOutputStream(OutputStream resultOutputStream) {
        this.resultOutputStream = resultOutputStream;
    }
}

