/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.sharding;

import java.util.List;
import one.harmony.common.Config;
import one.harmony.rpc.RPC;
import one.harmony.rpc.ShardingStructure;

public class Sharding {
    public static List<ShardingStructure.RPCRoutes> getShardingStructure() throws Exception {
        RPC rpc = new RPC(Config.node);
        ShardingStructure structure = (ShardingStructure)rpc.getShardingStructure().send();
        if (structure.hasError()) {
            throw new Exception(structure.getError().getMessage());
        }
        return (List)structure.getResult();
    }

    public static boolean validateShardIDs(int fromShardID, int toShardID, int shardCount) throws IllegalArgumentException {
        if (!Sharding.isValidShardID(fromShardID, shardCount)) {
            throw new IllegalArgumentException("Invalid fromShardID");
        }
        if (!Sharding.isValidShardID(toShardID, shardCount)) {
            throw new IllegalArgumentException("Invalid toShardID");
        }
        return true;
    }

    private static boolean isValidShardID(int shardID, int shardCount) {
        return shardID <= shardCount - 1;
    }

    public static String getHandlerFor(List<ShardingStructure.RPCRoutes> sharding, int shardID) throws IllegalArgumentException {
        for (ShardingStructure.RPCRoutes rpcRoute : sharding) {
            if (rpcRoute.getShardID() != shardID) continue;
            return rpcRoute.getHttp();
        }
        throw new IllegalArgumentException("No handler exists for the input shardID");
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Sharding.getShardingStructure());
    }
}

