/*
 * Decompiled with CFR 0.152.
 */
package one.microproject.rpi.powercontroller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import one.microproject.rpi.powercontroller.ClientException;
import one.microproject.rpi.powercontroller.PowerControllerClient;
import one.microproject.rpi.powercontroller.PowerControllerReadClient;
import one.microproject.rpi.powercontroller.client.PowerControllerClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerControllerClientBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PowerControllerClientBuilder.class);
    private URL baseURL;
    private String clientId;
    private String clientSecret;
    private Long timeout = 3L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private OkHttpClient client;
    private ObjectMapper mapper;

    public PowerControllerClientBuilder baseUrl(String baseURL) throws MalformedURLException {
        this.baseURL = new URL(baseURL);
        return this;
    }

    public PowerControllerClientBuilder withCredentials(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        return this;
    }

    public PowerControllerClientBuilder setTimeouts(Long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        return this;
    }

    public PowerControllerClientBuilder setHttpClient(OkHttpClient client) {
        this.client = client;
        return this;
    }

    public PowerControllerClientBuilder setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public PowerControllerClient build() {
        if (this.clientId == null || this.clientSecret == null) {
            throw new ClientException("Invalid client credentials !");
        }
        if (this.client == null) {
            LOG.info("default http client: timeouts={} {}", (Object)this.timeout, (Object)this.timeUnit);
            this.client = new OkHttpClient().newBuilder().connectTimeout(this.timeout.longValue(), this.timeUnit).callTimeout(this.timeout.longValue(), this.timeUnit).readTimeout(this.timeout.longValue(), this.timeUnit).writeTimeout(this.timeout.longValue(), this.timeUnit).build();
        }
        if (this.mapper == null) {
            LOG.info("default mapper");
            this.mapper = new ObjectMapper();
        }
        return new PowerControllerClientImpl(this.baseURL, this.clientId, this.clientSecret, this.client, this.mapper);
    }

    public PowerControllerReadClient buildReadClient() {
        return this.build();
    }

    public static PowerControllerClientBuilder builder() {
        return new PowerControllerClientBuilder();
    }
}

