/*
 * Decompiled with CFR 0.152.
 */
package one.microproject.rpi.powercontroller.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import one.microproject.rpi.powercontroller.ClientException;
import one.microproject.rpi.powercontroller.PowerControllerClient;
import one.microproject.rpi.powercontroller.dto.JobId;
import one.microproject.rpi.powercontroller.dto.JobInfo;
import one.microproject.rpi.powercontroller.dto.Measurements;
import one.microproject.rpi.powercontroller.dto.SetPortRequest;
import one.microproject.rpi.powercontroller.dto.SystemInfo;
import one.microproject.rpi.powercontroller.dto.SystemState;
import one.microproject.rpi.powercontroller.dto.TaskFilter;
import one.microproject.rpi.powercontroller.dto.TaskId;
import one.microproject.rpi.powercontroller.dto.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerControllerClientImpl
implements PowerControllerClient {
    private static final Logger LOG = LoggerFactory.getLogger(PowerControllerClientImpl.class);
    private static final String AUTHORIZATION = "Authorization";
    private static final String APPLICATION_JSON = "application/json";
    private static final String ERROR_MESSAGE = "Expected http=200, received http=";
    private final OkHttpClient client;
    private final ObjectMapper mapper;
    private final URL baseURL;
    private final String clientId;
    private final String clientSecret;

    public PowerControllerClientImpl(URL baseURL, String clientId, String clientSecret, OkHttpClient client, ObjectMapper mapper) {
        this.client = client;
        this.mapper = mapper;
        this.baseURL = baseURL;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public SystemInfo getSystemInfo() {
        try {
            Request request = new Request.Builder().url(this.baseURL + "/system/info").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).get().build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return (SystemInfo)this.mapper.readValue(response.body().string(), SystemInfo.class);
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public SystemState getSystemState() {
        try {
            Request request = new Request.Builder().url(this.baseURL + "/system/state").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).get().build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return (SystemState)this.mapper.readValue(response.body().string(), SystemState.class);
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public Measurements getMeasurements() {
        try {
            Request request = new Request.Builder().url(this.baseURL + "/system/measurements").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).get().build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return (Measurements)this.mapper.readValue(response.body().string(), Measurements.class);
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public Collection<JobInfo> getSystemJobs() {
        try {
            Request request = new Request.Builder().url(this.baseURL + "/system/jobs").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).get().build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return (Collection)this.mapper.readValue(response.body().string(), (TypeReference)new TypeReference<Collection<JobInfo>>(){});
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public JobId getKillAllJobId() {
        try {
            Request request = new Request.Builder().url(this.baseURL + "/system/jobs/killalljobid").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).get().build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return (JobId)this.mapper.readValue(response.body().string(), JobId.class);
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public Collection<TaskInfo> getAllTasks() {
        try {
            Request request = new Request.Builder().url(this.baseURL + "/system/tasks").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).get().build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return (Collection)this.mapper.readValue(response.body().string(), (TypeReference)new TypeReference<Collection<TaskInfo>>(){});
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public Collection<TaskInfo> getTasks(TaskFilter filter) {
        try {
            String requestBody = this.mapper.writeValueAsString((Object)filter);
            Request request = new Request.Builder().url(this.baseURL + "/system/tasks").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).put(RequestBody.create((String)requestBody, (MediaType)MediaType.parse((String)APPLICATION_JSON))).build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return (Collection)this.mapper.readValue(response.body().string(), (TypeReference)new TypeReference<Collection<TaskInfo>>(){});
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public boolean setPortState(Integer port, Boolean state) {
        try {
            SetPortRequest setPortRequest = new SetPortRequest(port, state);
            String requestBody = this.mapper.writeValueAsString((Object)setPortRequest);
            Request request = new Request.Builder().url(this.baseURL + "/system/port").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).put(RequestBody.create((String)requestBody, (MediaType)MediaType.parse((String)APPLICATION_JSON))).build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return 200 == response.code();
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public Optional<TaskId> submitTask(JobId id) {
        try {
            String requestBody = this.mapper.writeValueAsString((Object)id);
            Request request = new Request.Builder().url(this.baseURL + "/system/tasks/submit").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).put(RequestBody.create((String)requestBody, (MediaType)MediaType.parse((String)APPLICATION_JSON))).build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return Optional.of((TaskId)this.mapper.readValue(response.body().string(), TaskId.class));
            }
            LOG.info(ERROR_MESSAGE, (Object)response.code());
            return Optional.empty();
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public boolean cancelTask(TaskId id) {
        try {
            String requestBody = this.mapper.writeValueAsString((Object)id);
            Request request = new Request.Builder().url(this.baseURL + "/system/tasks/cancel").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).put(RequestBody.create((String)requestBody, (MediaType)MediaType.parse((String)APPLICATION_JSON))).build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return 200 == response.code();
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public boolean cancelAllTasks() {
        try {
            Request request = new Request.Builder().url(this.baseURL + "/system/tasks/cancel/all").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).put(RequestBody.create((String)"{}", (MediaType)MediaType.parse((String)APPLICATION_JSON))).build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return 200 == response.code();
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public boolean waitForTaskStarted(TaskId id) {
        try {
            String requestBody = this.mapper.writeValueAsString((Object)id);
            Request request = new Request.Builder().url(this.baseURL + "/system/tasks/wait/started").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).put(RequestBody.create((String)requestBody, (MediaType)MediaType.parse((String)APPLICATION_JSON))).build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return 200 == response.code();
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public boolean waitForTaskTermination(TaskId id) {
        try {
            String requestBody = this.mapper.writeValueAsString((Object)id);
            Request request = new Request.Builder().url(this.baseURL + "/system/tasks/wait/termination").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).put(RequestBody.create((String)requestBody, (MediaType)MediaType.parse((String)APPLICATION_JSON))).build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return 200 == response.code();
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public boolean cleanTaskQueue() {
        try {
            Request request = new Request.Builder().url(this.baseURL + "/system/tasks/clean").addHeader(AUTHORIZATION, PowerControllerClientImpl.createBasicAuthorizationFromCredentials(this.clientId, this.clientSecret)).put(RequestBody.create((String)"{}", (MediaType)MediaType.parse((String)APPLICATION_JSON))).build();
            Response response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                return 200 == response.code();
            }
            throw new ClientException(ERROR_MESSAGE + response.code());
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    public static String createBasicAuthorizationFromCredentials(String clientId, String clientSecret) {
        String authorization = clientId + ":" + clientSecret;
        byte[] encodedBytes = Base64.getEncoder().encode(authorization.getBytes());
        String encodedString = new String(encodedBytes);
        return "Basic " + encodedString;
    }
}

