/*
 * Decompiled with CFR 0.152.
 */
package one.valuelogic.vertx.web.problem;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nurkiewicz.typeof.TypeOf;
import io.vertx.core.json.DecodeException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.ThrowableProblem;

class ProblemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProblemFactory.class);

    private ProblemFactory() {
    }

    private static ThrowableProblem buildProblem(String path, Response.StatusType status, String details) {
        return ProblemFactory.buildProblem(Optional.ofNullable(path), status, details);
    }

    private static ThrowableProblem buildProblem(Optional<String> path, Response.StatusType status, String details) {
        ProblemBuilder problemBuilder = Problem.builder().withStatus(status).withTitle(status.getReasonPhrase()).withDetail(details);
        if (path.isPresent()) {
            problemBuilder.withInstance(URI.create(path.get()));
        }
        return problemBuilder.build();
    }

    static Problem create(Throwable e, @Nullable String path) {
        return (Problem)TypeOf.whenTypeOf((Object)e).is(JsonProcessingException.class).thenReturn(ex -> ProblemFactory.buildProblem(path, (Response.StatusType)Response.Status.BAD_REQUEST, ex.getMessage())).is(DecodeException.class).thenReturn(ex -> ProblemFactory.buildProblem(path, (Response.StatusType)Response.Status.BAD_REQUEST, ex.getMessage())).is(DefaultProblem.class).thenReturn(dProblem -> ProblemFactory.defaultToProblem(dProblem, path)).orElse(ex -> ProblemFactory.createInternalError(ex, path));
    }

    private static ThrowableProblem createInternalError(Throwable ex, String path) {
        LOG.error((Object)("Internal server error when handling path: " + path), ex);
        if (Objects.nonNull(ex)) {
            return ProblemFactory.buildProblem(path, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
        return ProblemFactory.buildProblem(path, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
    }

    private static ThrowableProblem defaultToProblem(DefaultProblem defaultProblem, String path) {
        if (Objects.isNull(defaultProblem.getStatus())) {
            return ProblemFactory.buildProblem(path, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, defaultProblem.getMessage());
        }
        return ProblemFactory.buildProblem(path, defaultProblem.getStatus(), defaultProblem.getMessage());
    }
}

