/*
 * Decompiled with CFR 0.152.
 */
package one.valuelogic.vertx.web.problem;

import io.vertx.core.Handler;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.Json;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.rxjava.core.http.HttpServerResponse;
import io.vertx.rxjava.ext.web.RoutingContext;
import javax.ws.rs.core.Response;
import one.valuelogic.vertx.web.problem.ProblemFactory;
import org.zalando.problem.Problem;

public class ProblemHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(ProblemHandler.class);
    private static final String INTERNAL_SERVER_ERROR = "{\"title\":\"" + Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase() + "\",\"status\":\"" + Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() + "\"}";

    public void handle(RoutingContext context) {
        Problem problem = ProblemFactory.create(context.failure(), context.request().path());
        ProblemHandler.write(context.response(), problem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServerResponse response, Problem problem) {
        int statusCode = problem.getStatus() != null ? problem.getStatus().getStatusCode() : Response.Status.OK.getStatusCode();
        response.setChunked(true).putHeader("Content-Type", "application/problem+json");
        try {
            response.setStatusCode(statusCode).write(Json.encode((Object)problem));
        }
        catch (EncodeException e) {
            LOG.error((Object)"Error while writing problem to JSON", (Throwable)e);
            response.setStatusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).write(INTERNAL_SERVER_ERROR);
        }
        finally {
            response.end();
        }
    }

    public static Handler<RoutingContext> create() {
        return new ProblemHandler();
    }
}

