/** Copyright (c) 2020, Phil Rice. Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */
package one.xingyi.core.script
import one.xingyi.core.UtilsSpec
import one.xingyi.core.builder.HasId

class GetEntityRequestTest extends UtilsSpec {

  behavior of "GetEntityRequest"

  val reqNoHeader = GetEntityRequest("someId", "somehost", None)
  val reqHeader = GetEntityRequest("someId", "somehost", Some("xingyiheader"))

  val hasId = implicitly[HasId[GetEntityRequest, String]]
  val hasHost = implicitly[HasHost[GetEntityRequest]]
  val toContentType = implicitly[ToContentType[GetEntityRequest]]

  it should "have a 'HasId'" in {
    hasId(reqHeader) shouldBe "someId"
  }

  it should "have a 'has host'" in {
    hasHost(reqHeader) shouldBe "somehost"
  }

  it should "have a 'toContentType'" in {
    toContentType(reqHeader) shouldBe "xingyiheader"
    toContentType(reqNoHeader) shouldBe "application/xingyi."
  }

}
