/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.processors;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.xingyi.optics.annotations.processors.NameAndType;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.processors.Utils;
import one.xingyi.optics.annotations.processors.WithDebug;

public class RecordedTraversals {
    public final boolean debug;
    public final List<NameAndType> classAndFields;
    static BiFunction<WithDebug<PackageAndClass>, String, RecordedTraversals> parse = (from, s) -> {
        String[] lines = s.split("\n");
        List<NameAndType> namesAndTypes = Arrays.stream(lines).map(String::trim).filter(s1 -> !s1.isEmpty()).flatMap(line -> {
            String name = Utils.firstPart(line, ":", null);
            String packageAndClass = Utils.lastPart(line, ":", null);
            if (name == null || packageAndClass == null) {
                return Stream.empty();
            }
            return Stream.of(new NameAndType(name, PackageAndClass.from(packageAndClass)));
        }).collect(Collectors.toList());
        return new RecordedTraversals(from.debug, namesAndTypes);
    };
    static Function<RecordedTraversals, String> printer = s -> s.classAndFields.stream().map(NameAndType::getString).collect(Collectors.joining("\n"));

    public RecordedTraversals(boolean debug, List<NameAndType> classAndFields) {
        this.debug = debug;
        this.classAndFields = classAndFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordedTraversals)) {
            return false;
        }
        RecordedTraversals other = (RecordedTraversals)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        List<NameAndType> this$classAndFields = this.getClassAndFields();
        List<NameAndType> other$classAndFields = other.getClassAndFields();
        return !(this$classAndFields == null ? other$classAndFields != null : !((Object)this$classAndFields).equals(other$classAndFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordedTraversals;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebug() ? 79 : 97);
        List<NameAndType> $classAndFields = this.getClassAndFields();
        result = result * 59 + ($classAndFields == null ? 43 : ((Object)$classAndFields).hashCode());
        return result;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public List<NameAndType> getClassAndFields() {
        return this.classAndFields;
    }

    public String toString() {
        return "RecordedTraversals(debug=" + this.isDebug() + ", classAndFields=" + this.getClassAndFields() + ")";
    }
}

