/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.serialise;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.tools.FileObject;
import one.xingyi.optics.annotations.interfaces.IFunctionWithException;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.serialise.IAnnotationProcessorLoader;

class AnnotationProcessorLoader<From, T>
implements IAnnotationProcessorLoader<From, T> {
    private final Function<From, PackageAndClass> fromToClassName;
    private final IFunctionWithException<PackageAndClass, FileObject> classNameToFileObject;
    private final BiFunction<From, String, T> parser;

    @Override
    public T load(From from) throws IOException {
        FileObject fileObject = this.classNameToFileObject.apply(this.fromToClassName.apply(from));
        File file = new File(fileObject.toUri());
        try (FileReader reader = new FileReader(file);){
            BufferedReader bufferedReader = new BufferedReader(reader);
            T t = this.parser.apply(from, bufferedReader.lines().collect(Collectors.joining("\n")));
            return t;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationProcessorLoader)) {
            return false;
        }
        AnnotationProcessorLoader other = (AnnotationProcessorLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Function<From, PackageAndClass> this$fromToClassName = this.getFromToClassName();
        Function<From, PackageAndClass> other$fromToClassName = other.getFromToClassName();
        if (this$fromToClassName == null ? other$fromToClassName != null : !this$fromToClassName.equals(other$fromToClassName)) {
            return false;
        }
        IFunctionWithException<PackageAndClass, FileObject> this$classNameToFileObject = this.getClassNameToFileObject();
        IFunctionWithException<PackageAndClass, FileObject> other$classNameToFileObject = other.getClassNameToFileObject();
        if (this$classNameToFileObject == null ? other$classNameToFileObject != null : !this$classNameToFileObject.equals(other$classNameToFileObject)) {
            return false;
        }
        BiFunction<From, String, T> this$parser = this.getParser();
        BiFunction<From, String, T> other$parser = other.getParser();
        return !(this$parser == null ? other$parser != null : !this$parser.equals(other$parser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnnotationProcessorLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<From, PackageAndClass> $fromToClassName = this.getFromToClassName();
        result = result * 59 + ($fromToClassName == null ? 43 : $fromToClassName.hashCode());
        IFunctionWithException<PackageAndClass, FileObject> $classNameToFileObject = this.getClassNameToFileObject();
        result = result * 59 + ($classNameToFileObject == null ? 43 : $classNameToFileObject.hashCode());
        BiFunction<From, String, T> $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        return result;
    }

    public Function<From, PackageAndClass> getFromToClassName() {
        return this.fromToClassName;
    }

    public IFunctionWithException<PackageAndClass, FileObject> getClassNameToFileObject() {
        return this.classNameToFileObject;
    }

    public BiFunction<From, String, T> getParser() {
        return this.parser;
    }

    public String toString() {
        return "AnnotationProcessorLoader(fromToClassName=" + this.getFromToClassName() + ", classNameToFileObject=" + this.getClassNameToFileObject() + ", parser=" + this.getParser() + ")";
    }

    public AnnotationProcessorLoader(Function<From, PackageAndClass> fromToClassName, IFunctionWithException<PackageAndClass, FileObject> classNameToFileObject, BiFunction<From, String, T> parser) {
        this.fromToClassName = fromToClassName;
        this.classNameToFileObject = classNameToFileObject;
        this.parser = parser;
    }
}

