/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.serialise;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.xingyi.optics.annotations.serialise.IAnnotationProcessorStorer;

class DebuggingAnnotationProcessorStorer<From, To>
implements IAnnotationProcessorStorer<From, To> {
    private final IAnnotationProcessorStorer<From, To> storer;
    private final Predicate<From> debugPredicate;
    private final Consumer<String> logger;

    @Override
    public void store(From from, To to) throws IOException {
        try {
            if (this.debugPredicate.test(from)) {
                this.logger.accept("Stored " + from + " giving " + to);
            }
            this.storer.store(from, to);
            if (this.debugPredicate.test(from)) {
                this.logger.accept("Stored " + from);
            }
        }
        catch (IOException | RuntimeException e) {
            this.logger.accept("Error storing " + from + ", " + to + e.getMessage());
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebuggingAnnotationProcessorStorer)) {
            return false;
        }
        DebuggingAnnotationProcessorStorer other = (DebuggingAnnotationProcessorStorer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IAnnotationProcessorStorer<From, To> this$storer = this.getStorer();
        IAnnotationProcessorStorer<From, To> other$storer = other.getStorer();
        if (this$storer == null ? other$storer != null : !this$storer.equals(other$storer)) {
            return false;
        }
        Predicate<From> this$debugPredicate = this.getDebugPredicate();
        Predicate<From> other$debugPredicate = other.getDebugPredicate();
        if (this$debugPredicate == null ? other$debugPredicate != null : !this$debugPredicate.equals(other$debugPredicate)) {
            return false;
        }
        Consumer<String> this$logger = this.getLogger();
        Consumer<String> other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DebuggingAnnotationProcessorStorer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IAnnotationProcessorStorer<From, To> $storer = this.getStorer();
        result = result * 59 + ($storer == null ? 43 : $storer.hashCode());
        Predicate<From> $debugPredicate = this.getDebugPredicate();
        result = result * 59 + ($debugPredicate == null ? 43 : $debugPredicate.hashCode());
        Consumer<String> $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public IAnnotationProcessorStorer<From, To> getStorer() {
        return this.storer;
    }

    public Predicate<From> getDebugPredicate() {
        return this.debugPredicate;
    }

    public Consumer<String> getLogger() {
        return this.logger;
    }

    public String toString() {
        return "DebuggingAnnotationProcessorStorer(storer=" + this.getStorer() + ", debugPredicate=" + this.getDebugPredicate() + ", logger=" + this.getLogger() + ")";
    }

    public DebuggingAnnotationProcessorStorer(IAnnotationProcessorStorer<From, To> storer, Predicate<From> debugPredicate, Consumer<String> logger) {
        this.storer = storer;
        this.debugPredicate = debugPredicate;
        this.logger = logger;
    }
}

