/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.processors;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class PackageAndClass {
    private final PackageAndClass holdingClass;
    private final String packageName;
    private final String className;
    public static Map<String, PackageAndClass> primitives = PackageAndClass.makePrimitives();

    public PackageAndClass mapClassName(Function<String, String> fn) {
        return new PackageAndClass(this.holdingClass, this.packageName, fn.apply(this.className));
    }

    private static Map<String, PackageAndClass> makePrimitives() {
        HashMap<String, PackageAndClass> result = new HashMap<String, PackageAndClass>();
        result.put("int", new PackageAndClass(null, "java.lang", "Integer"));
        result.put("long", new PackageAndClass(null, "java.lang", "Long"));
        result.put("double", new PackageAndClass(null, "java.lang", "Double"));
        result.put("boolean", new PackageAndClass(null, "java.lang", "Boolean"));
        result.put("float", new PackageAndClass(null, "java.lang", "Float"));
        result.put("char", new PackageAndClass(null, "java.lang", "Character"));
        result.put("byte", new PackageAndClass(null, "java.lang", "Byte"));
        result.put("short", new PackageAndClass(null, "java.lang", "Short"));
        result.put("void", new PackageAndClass(null, "java.lang", "Void"));
        return result;
    }

    public static PackageAndClass from(String fullName) {
        if (fullName == null) {
            return null;
        }
        int index = fullName.indexOf("<");
        if (index > 0) {
            return PackageAndClass.fromHolding(fullName, index);
        }
        PackageAndClass result = primitives.get(fullName);
        if (result != null) {
            return result;
        }
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot == -1) {
            return new PackageAndClass(null, "", fullName);
        }
        return new PackageAndClass(null, fullName.substring(0, lastDot), fullName.substring(lastDot + 1));
    }

    public static PackageAndClass fromHolding(String fullName, int indexOfFirst) {
        String first = fullName.substring(0, indexOfFirst);
        String last = fullName.substring(indexOfFirst + 1).replace(">", "");
        PackageAndClass holding = PackageAndClass.from(first);
        PackageAndClass held = PackageAndClass.from(last);
        return new PackageAndClass(holding, held.packageName, held.className);
    }

    public String getShortName() {
        return this.holdingClass != null ? this.holdingClass.getShortName() + "<" + this.className + ">" : this.className;
    }

    public String getString() {
        return this.packageName + "." + this.className;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackageAndClass)) {
            return false;
        }
        PackageAndClass other = (PackageAndClass)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PackageAndClass this$holdingClass = this.getHoldingClass();
        PackageAndClass other$holdingClass = other.getHoldingClass();
        if (this$holdingClass == null ? other$holdingClass != null : !((Object)this$holdingClass).equals(other$holdingClass)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        return !(this$className == null ? other$className != null : !this$className.equals(other$className));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PackageAndClass;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PackageAndClass $holdingClass = this.getHoldingClass();
        result = result * 59 + ($holdingClass == null ? 43 : ((Object)$holdingClass).hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        return result;
    }

    public PackageAndClass getHoldingClass() {
        return this.holdingClass;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return "PackageAndClass(holdingClass=" + this.getHoldingClass() + ", packageName=" + this.getPackageName() + ", className=" + this.getClassName() + ")";
    }

    public PackageAndClass(PackageAndClass holdingClass, String packageName, String className) {
        this.holdingClass = holdingClass;
        this.packageName = packageName;
        this.className = className;
    }
}

