package com.chianti;

import android.app.Activity;
import android.app.Dialog;
import android.os.Handler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebView;


public abstract class AbsAgentWebUIController {

	public static boolean HAS_DESIGN_LIB = false;
	private Activity mActivity;
	private WebParentLayout mWebParentLayout;
	private volatile boolean mIsBindWebParent = false;
	protected AbsAgentWebUIController mAgentWebUIControllerDelegate;
	protected String TAG = this.getClass().getSimpleName();

	static {
		try {
			Class.forName("android.support.design.widget.Snackbar");
			Class.forName("android.support.design.widget.BottomSheetDialog");
			HAS_DESIGN_LIB = true;
		} catch (Throwable ignore) {
			HAS_DESIGN_LIB = false;
		}
	}

	protected AbsAgentWebUIController create() {
		return HAS_DESIGN_LIB ? new DefaultDesignUIController() : new DefaultUIController();
	}

	protected AbsAgentWebUIController getDelegate() {
		AbsAgentWebUIController mAgentWebUIController = this.mAgentWebUIControllerDelegate;
		if (mAgentWebUIController == null) {
			this.mAgentWebUIControllerDelegate = mAgentWebUIController = create();
		}
		return mAgentWebUIController;
	}

	final synchronized void bindWebParent(WebParentLayout webParentLayout, Activity activity) {
		if (!mIsBindWebParent) {
			mIsBindWebParent = true;
			this.mWebParentLayout = webParentLayout;
			this.mActivity = activity;
			bindSupportWebParent(webParentLayout, activity);
		}
	}

	protected void toDismissDialog(Dialog dialog) {
		if (dialog != null && dialog.isShowing()) {
			dialog.dismiss();
		}
	}

	protected void toShowDialog(Dialog dialog) {
		if (dialog != null && !dialog.isShowing()) {
			dialog.show();
		}
	}

	protected abstract void bindSupportWebParent(WebParentLayout webParentLayout, Activity activity);

	public abstract void onJsAlert(WebView view, String url, String message);

	public abstract void onOpenPagePrompt(WebView view, String url, Handler.Callback callback);

	public abstract void onJsConfirm(WebView view, String url, String message, JsResult jsResult);

	public abstract void onSelectItemsPrompt(WebView view, String url, String[] ways, Handler.Callback callback);

	public abstract void onForceDownloadAlert(String url, Handler.Callback callback);

	public abstract void onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult jsPromptResult);

	public abstract void onMainFrameError(WebView view, int errorCode, String description, String failingUrl);

	public abstract void onShowMainFrame();

	public abstract void onLoading(String msg);

	public abstract void onCancelLoading();

	public abstract void onShowMessage(String message, String intent);

	public abstract void onPermissionsDeny(String[] permissions, String permissionType, String action);


}
