package com.chianti;

import android.content.Context;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import io.reactivex.Observable;

import java.util.HashMap;
import java.util.Map;

public class AppsFlyerHelper {

    public static Observable<ParamsMapAndLink> appsFlyerHelper(Context context, String appsflyer, String link) {
        Map<String, String> map = new HashMap<>();
        return Observable.create(emitter -> {
            AppsFlyerLib.getInstance().init(appsflyer, new AppsFlyerConversionListener() {
                @Override
                public void onConversionDataSuccess(Map<String, Object> conversionData) {
                    for (String attrName : conversionData.keySet()) {
                        map.put(attrName, String.valueOf(conversionData.get(attrName)).replace(" ", ""));
                    }
                    ParamsMapAndLink params = new ParamsMapAndLink(map, link);
                    emitter.onNext(params);
                }

                @Override
                public void onConversionDataFail(String s) {
                    map.put(ChiantiElement.APPS_ID.getName(), s.replace(" ", "_"));
                    ParamsMapAndLink params = new ParamsMapAndLink(map, link);
                    emitter.onNext(params);
                }

                @Override
                public void onAppOpenAttribution(Map<String, String> map) {

                }

                @Override
                public void onAttributionFailure(String s) {

                }
            }, context);
            AppsFlyerLib.getInstance().start(context);
            AppsFlyerLib.getInstance().setDebugLog(true);


        });
    }
}
