package com.chianti;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.coolindicator.sdk.CoolIndicator;
import com.just.agentweb.BaseIndicatorView;

public class CoolInd extends BaseIndicatorView {


    private CoolIndicator mCoolIndicator = null;


    public CoolInd(Context context) {
        this(context, null);
    }

    public CoolInd(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public CoolInd(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        GradientDrawable shape = new GradientDrawable();
        shape.setShape(GradientDrawable.OVAL);
        shape.setColors(new int[] {R.attr.colorAccent, R.attr.colorPrimary});
        mCoolIndicator = CoolIndicator.create((Activity) context);
        mCoolIndicator.setProgressDrawable(shape);
//        mCoolIndicator.setProgressDrawable(context.getResources().getDrawable(com.coolindicator.sdk.R.drawable.default_drawable_indicator, context.getTheme()));

        this.addView(mCoolIndicator, offerLayoutParams());

    }

    @Override
    public void show() {
        this.setVisibility(View.VISIBLE);
        mCoolIndicator.start();
    }

    @Override
    public void setProgress(int newProgress) {
    }

    @Override
    public void hide() {
        mCoolIndicator.complete();
    }

    @Override
    public LayoutParams offerLayoutParams() {
        return new LayoutParams(-1, AgentWebUtils.dp2px(getContext(), 6));
    }
}
