package com.chianti;

import android.app.Activity;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.*;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.just.agentweb.*;

import java.lang.ref.WeakReference;
import java.util.List;

import static com.just.agentweb.ActionActivity.KEY_FROM_INTENTION;



public class DefaultChromeClient extends MiddlewareWebChromeBase {

	private WeakReference<Activity> mActivityWeakReference = null;

	private String TAG = DefaultChromeClient.class.getSimpleName();

	public static final String ANDROID_WEBCHROMECLIENT_PATH = "android.webkit.WebChromeClient";

	private WebChromeClient mWebChromeClient;

	private boolean mIsWrapper = false;

	private IVideo mIVideo;

	private PermissionInterceptor mPermissionInterceptor;

	private WebView mWebView;

	private String mOrigin = null;

	private GeolocationPermissions.Callback mCallback = null;

	public static final int FROM_CODE_INTENTION = 0x18;

	public static final int FROM_CODE_INTENTION_LOCATION = FROM_CODE_INTENTION << 2;

	private WeakReference<AbsAgentWebUIController> mAgentWebUIController = null;

	private IndicatorController mIndicatorController;

	private Object mFileChooser;

	DefaultChromeClient(Activity activity,
                        IndicatorController indicatorController,
                        WebChromeClient chromeClient,
                        @Nullable IVideo iVideo,
                        PermissionInterceptor permissionInterceptor, WebView webView) {
		super(chromeClient);
		this.mIndicatorController = indicatorController;
		mIsWrapper = chromeClient != null;
		this.mWebChromeClient = chromeClient;
		mActivityWeakReference = new WeakReference<>(activity);
		this.mIVideo = iVideo;
		this.mPermissionInterceptor = permissionInterceptor;
		this.mWebView = webView;
		mAgentWebUIController = new WeakReference<>(AgentWebUtils.getAgentWebUIControllerByWebView(webView));
	}


	@Override
	public void onProgressChanged(WebView view, int newProgress) {
		super.onProgressChanged(view, newProgress);
		if (mIndicatorController != null) {
			mIndicatorController.progress(view, newProgress);
		}
	}

	@Override
	public void onReceivedTitle(WebView view, String title) {
		if (mIsWrapper) {
			super.onReceivedTitle(view, title);
		}
	}

	@Override
	public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
		if (mAgentWebUIController.get() != null) {
			mAgentWebUIController.get().onJsAlert(view, url, message);
		}
		result.confirm();
		return true;
	}


	@Override
	public void onReceivedIcon(WebView view, Bitmap icon) {
		super.onReceivedIcon(view, icon);
	}

	@Override
	public void onGeolocationPermissionsHidePrompt() {
		super.onGeolocationPermissionsHidePrompt();
	}

//	//location
	@Override
	public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
		onGeolocationPermissionsShowPromptInternal(origin, callback);
	}

	private void onGeolocationPermissionsShowPromptInternal(String origin, GeolocationPermissions.Callback callback) {
		if (mPermissionInterceptor != null) {
//			if (mPermissionInterceptor.intercept(this.mWebView.getUrl(), AgentWebPermissions.LOCATION, "location")) {
//				callback.invoke(origin, false, false);
//				return;
//			}
		}
//		Activity mActivity = mActivityWeakReference.get();
//		if (mActivity == null) {
//			callback.invoke(origin, false, false);
//			return;
//		}
//		List<String> deniedPermissions = null;
//		if ((deniedPermissions = AgentWebUtils.getDeniedPermissions(mActivity, AgentWebPermissions.LOCATION)).isEmpty()) {
//			callback.invoke(origin, true, false);
//		} else {
//			Action mAction = Action.createPermissionsAction(deniedPermissions.toArray(new String[]{}));
//			mAction.setFromIntention(FROM_CODE_INTENTION_LOCATION);
//			ActionActivity.setPermissionListener(mPermissionListener);
//			this.mCallback = callback;
//			this.mOrigin = origin;
//			ActionActivity.start(mActivity, mAction);
//		}
	}

	private final ActionActivity.PermissionListener mPermissionListener = (permissions, grantResults, extras) -> {
//		if (extras.getInt(KEY_FROM_INTENTION) == FROM_CODE_INTENTION_LOCATION) {
//			boolean hasPermission = AgentWebUtils.hasPermission(mActivityWeakReference.get(), permissions);
//			if (mCallback != null) {
//				if (hasPermission) {
//					mCallback.invoke(mOrigin, false, false);
//				} else {
//					mCallback.invoke(mOrigin, false, false);
//				}
//				mCallback = null;
//				mOrigin = null;
//			}
//			if (!hasPermission && null != mAgentWebUIController.get()) {
//				mAgentWebUIController
//						.get()
//						.onPermissionsDeny(
//								AgentWebPermissions.LOCATION,
//								AgentWebPermissions.ACTION_LOCATION,
//								"Location");
//			}
//		}
	};

	@Override
	public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
		try {
			if (this.mAgentWebUIController.get() != null) {
				this.mAgentWebUIController.get().onJsPrompt(mWebView, url, message, defaultValue, result);
			}
		} catch (Exception e) {

		}
		return true;
	}

	@Override
	public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
		if (mAgentWebUIController.get() != null) {
			mAgentWebUIController.get().onJsConfirm(view, url, message, result);
		}
		return true;
	}


	@Override
	public void onExceededDatabaseQuota(String url, String databaseIdentifier, long quota, long estimatedDatabaseSize, long totalQuota, WebStorage.QuotaUpdater quotaUpdater) {
		quotaUpdater.updateQuota(totalQuota * 2);
	}

	@Override
	public void onReachedMaxAppCacheSize(long requiredStorage, long quota, WebStorage.QuotaUpdater quotaUpdater) {
		quotaUpdater.updateQuota(requiredStorage * 2);
	}


	@Override
	public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
		return openFileChooserAboveL(webView, filePathCallback, fileChooserParams);
	}

	private boolean openFileChooserAboveL(WebView webView, ValueCallback<Uri[]> valueCallbacks, FileChooserParams fileChooserParams) {
		Activity mActivity = this.mActivityWeakReference.get();
		if (mActivity == null || mActivity.isFinishing()) {
			return false;
		}
		return AgentWebUtils.showFileChooserCompat(mActivity,
				mWebView,
				valueCallbacks,
				fileChooserParams,
				this.mPermissionInterceptor,
				null,
				null,
				null
		);
	}

	@Override
	public void openFileChooser(ValueCallback<Uri> uploadFile, String acceptType, String capture) {
		createAndOpenCommonFileChooser(uploadFile, acceptType);
	}

	@Override
	public void openFileChooser(ValueCallback<Uri> valueCallback) {
		createAndOpenCommonFileChooser(valueCallback, "*/*");
	}

	@Override
	public void openFileChooser(ValueCallback valueCallback, String acceptType) {
		createAndOpenCommonFileChooser(valueCallback, acceptType);
	}


	private void createAndOpenCommonFileChooser(ValueCallback valueCallback, String mimeType) {
		Activity mActivity = this.mActivityWeakReference.get();
		if (mActivity == null || mActivity.isFinishing()) {
			valueCallback.onReceiveValue(new Object());
			return;
		}
		AgentWebUtils.showFileChooserCompat(mActivity,
				mWebView,
				null,
				null,
				this.mPermissionInterceptor,
				valueCallback,
				mimeType,
				null
		);
	}

	@Override
	public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
		super.onConsoleMessage(consoleMessage);
		return true;
	}

	@Override
	public void onShowCustomView(View view, CustomViewCallback callback) {
		if (mIVideo != null) {
			mIVideo.onShowCustomView(view, callback);
		}
	}

	@Override
	public void onHideCustomView() {
		if (mIVideo != null) {
			mIVideo.onHideCustomView();
		}
	}
}
