package com.chianti;


import android.content.SharedPreferences;
import android.net.Uri;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onesignal.OSNotificationOpenedResult;
import com.onesignal.OneSignal;
import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MmmOneSignalPushClicker implements OneSignal.OSNotificationOpenedHandler {

    private final SharedPreferences preferences;

    public MmmOneSignalPushClicker(SharedPreferences sharedPreferences) {
        this.preferences = sharedPreferences;
    }

    @Override
    public void notificationOpened(OSNotificationOpenedResult result) {
        if (result != null) {

            JSONObject object = result.getNotification().getAdditionalData();

            ObjectMapper objectMapper = new ObjectMapper();
            Map<String, String> map = new HashMap<>();

            try {
                map = objectMapper.readValue(object.toString(),
                        new TypeReference<Map<String, String>>() {
                        });
            } catch (IOException e) {
                e.printStackTrace();
            }

            String lnk = preferences.getString(ChiantiElement.SHAREDPREF_LINK.getName(), ChiantiElement.SHAREDPREF_LINK.getName());

            Uri uri = Uri.parse(lnk);
            Uri.Builder builder = uri.buildUpon();

            if (map.containsKey(ChiantiElement.MESSAGE_ID.getName()))
                builder.appendQueryParameter(ChiantiElement.PUSH_ID.getName(), map.get(ChiantiElement.MESSAGE_ID.getName()));

//            for (String key : map.keySet()) {
//                builder.appendQueryParameter(key, map.get(key));
//            }
            lnk = builder.build().toString();

            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(ChiantiElement.SHAREDPREF_LINK.getName(), lnk);
            editor.apply();
        }
    }
}
