package com.chianti;

import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import io.reactivex.Observable;

import java.util.HashMap;
import java.util.Map;

import static com.chianti.ServiceAdvertisingId.serviceAdvertisingId;
import static com.chianti.ServiceDeepFB.serviceDeepFB;
import static com.chianti.ServiceFirebaseAndAppsFlyer.serviceFirebaseAndAppsFlyer;
import static com.chianti.ServiceIpApi.serviceIpApi;
import static com.chianti.ServiceUserInfo.serviceUserInfo;


public class ReactChianti {


    public static Observable<ParamsMapAndLink> reactToSuperServer(Context context) {
        return Observable.zip(serviceIpApi(),
                serviceAdvertisingId(context),
                serviceUserInfo(context),
                serviceDeepFB(context),
                serviceFirebaseAndAppsFlyer(context),
                (map, map2, map3, map4, appsFlyer) -> {
                    Map<String, String> hashMap = new HashMap<>();
                    hashMap.put(ChiantiElement.APPS_ID.getName(), AppsFlyerLib.getInstance().getAppsFlyerUID(context));
                    hashMap.putAll(map);
                    hashMap.putAll(map2);
                    hashMap.putAll(map3);
                    hashMap.putAll(map4);
                    hashMap.putAll(appsFlyer.getMap());
//                    Log.e("PARAM", String.valueOf(hashMap));
                    return new ParamsMapAndLink(hashMap, appsFlyer.getUrl());
                });
    }

}