package com.chianti;

import android.annotation.SuppressLint;
import android.content.Context;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

import java.util.HashMap;
import java.util.Map;

public class ServiceAdvertisingId {

    @SuppressLint("CheckResult")
    public static Observable<Map<String, String>> serviceAdvertisingId(Context context) {
        Map<String, String> stringHashMap = new HashMap<>();
        return Observable.create(emitter -> {
            Single.fromCallable(() -> AdvertisingIdClient.getAdvertisingIdInfo(context).getId())
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribeOn(Schedulers.io())
                    .subscribe(id -> {
                        stringHashMap.put(ChiantiElement.UID.getName(), id);
                        emitter.onNext(stringHashMap);
                    }, throwable -> {
                        stringHashMap.put(ChiantiElement.UID.getName(), "null");
                        emitter.onNext(stringHashMap);
                    });
        });
    }

}
