package com.chianti;

import android.content.Context;
import com.facebook.applinks.AppLinkData;
import io.reactivex.Observable;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ServiceDeepFB {

    public static Observable<Map<String, String>> serviceDeepFB(Context context) {
        return Observable.create(emitter -> {
            AppLinkData.fetchDeferredAppLinkData(context, linkData -> {
                Map<String, String> stringHashMap = new HashMap<>();
                if (linkData != null) {
                    String query = Objects.requireNonNull(linkData.getTargetUri()).getQuery();
                    if (query != null) {
                        String[] deepvaluepairs = query.split("&");
                        for (String pair : deepvaluepairs) {
                            String[] entry = pair.split("=");
                            stringHashMap.put(entry[0].trim(), entry[1].trim());
                        }
                        emitter.onNext(stringHashMap);
                    }
                } else {
                    emitter.onNext(stringHashMap);
                }
            });
        });
    }
}
