package com.chianti;

import android.content.Context;
import android.content.SharedPreferences;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;
import io.reactivex.Observable;

public class ServiceFirebase {

    public static Observable<ParamFirebase> serviceFirebase(Context context, String key, String apps) {
        return Observable.create(emitter -> {
            FirebaseDatabase.getInstance().getReference()
                    .addValueEventListener(new ValueEventListener() {
                        @Override
                        public void onDataChange(@NonNull DataSnapshot snapshot) {
                            String link = snapshot.child(key).getValue(String.class);
                            String flr = snapshot.child(apps).getValue(String.class);
                            if (link != null && URLUtil.isValidUrl(link) && flr != null) {
                                SharedPreferences sp = context.getSharedPreferences(context.getPackageName(), Context.MODE_PRIVATE);
                                SharedPreferences.Editor editor = sp.edit();
                                editor.putString(ChiantiElement.SUPPER_APP.getName(), link);
                                editor.apply();

                                ParamFirebase paramFirebase = new ParamFirebase(link, flr);
                                emitter.onNext(paramFirebase);
                            } else {
                                emitter.onError(new Throwable());
                            }
                        }

                        @Override
                        public void onCancelled(@NonNull DatabaseError error) {
                            emitter.onError(new Throwable());
                        }
                    });
        });
    }

}
