package com.chianti;

import android.annotation.SuppressLint;
import android.content.Context;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

import static com.chianti.AppsFlyerHelper.appsFlyerHelper;
import static com.chianti.ServiceFirebase.serviceFirebase;

public class ServiceFirebaseAndAppsFlyer {

    @SuppressLint("CheckResult")
    public static Observable<ParamsMapAndLink> serviceFirebaseAndAppsFlyer(Context context) {
        return Observable.create(emitter -> {
            serviceFirebase(context, context.getPackageName().split("\\.")[0], context.getPackageName().split("\\.")[1])
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribeOn(Schedulers.io())
                    .flatMap(text -> appsFlyerHelper(context, text.getmAppsKey(), text.getmLink()))
                    .subscribe(emitter::onNext, emitter::onError);
        });
    }

}
