package com.chianti;

import android.annotation.SuppressLint;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ServiceIpApi {

    @SuppressLint("CheckResult")
    public static Observable<Map<String, String>> serviceIpApi() {
        Map<String, String> map = new HashMap<>();
        return Observable.create(emitter -> {
            RetrofitService.getInstance("http://ip-api.com/")
                    .getNetworkClient()
                    .getIp()
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribeOn(Schedulers.io())
                    .subscribe((paramsIpApi, throwable) -> {
                        if (paramsIpApi != null) {
                            map.put("offsetIpApi", paramsIpApi.offset.toLowerCase().replace(" ", "_"));
                            map.put("countryCodeIpApi", paramsIpApi.countryCode.toLowerCase().replace(" ", "_"));
                            map.put("regionNameIpApi", paramsIpApi.region.toLowerCase().replace(" ", "_"));

                        } else if (throwable != null)
                            map.put("ipApi", Objects.requireNonNull(throwable.getMessage()).replace(" ", "_"));

                        emitter.onNext(map);
                    });
        });
    }

}
