package com.chianti;

import android.content.Context;
import android.telephony.TelephonyManager;
import io.reactivex.Observable;

import java.util.*;

public class ServiceUserInfo {

    public static Observable<Map<String, String>> serviceUserInfo(Context context) {
        return Observable.create(emitter -> {
            Map<String, String> local = new HashMap<>();

            TimeZone tz = TimeZone.getDefault();
            Date now = new Date();
            int offsetFromUtc = tz.getOffset(now.getTime()) / 1000;
            TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            String cc = tm.getNetworkCountryIso();

            local.put(ChiantiElement.BIND.getName(), context.getPackageName());
            local.put(ChiantiElement.OFFSET.getName(), String.valueOf(offsetFromUtc));
            local.put(ChiantiElement.COUNTRY.getName(), cc.toLowerCase());
            local.put(ChiantiElement.COUNTRY_CODE.getName(), Locale.getDefault().getCountry().toLowerCase());
            local.put(ChiantiElement.LANG.getName(), Locale.getDefault().getLanguage().toLowerCase());
            emitter.onNext(local);


        });
    }
}
