/*
 * Decompiled with CFR 0.152.
 */
package online.xcodes.ip;

import java.util.Objects;
import java.util.Set;

public class IPUtil {
    private static final String ANY_IP = "*";

    public static boolean isWhiteIp(String ip, Set<String> whiteIps) {
        if (whiteIps == null || whiteIps.isEmpty()) {
            return false;
        }
        if (whiteIps.contains(ANY_IP)) {
            return true;
        }
        if (ip == null || !ip.matches("^[\\d]+\\.[\\d]+\\.[\\d]+\\.[\\d]+$")) {
            return false;
        }
        return whiteIps.stream().anyMatch(cidr -> IPUtil.isInRange(ip, cidr));
    }

    public static boolean isInRange(String ip, String cidr) {
        if (ip == null || cidr == null || !cidr.contains("/")) {
            return Objects.equals(ip, cidr);
        }
        String[] cidrArray = cidr.split("/", 2);
        int mask = -1 << 32 - Integer.parseInt(cidrArray[1]);
        String[] ips = ip.split("\\.");
        String[] cidrIps = cidrArray[0].split("\\.");
        try {
            return ips.length == 4 && cidrIps.length == 4 && (IPUtil.ipv42Int(ips) & mask) == (IPUtil.ipv42Int(cidrIps) & mask);
        }
        catch (NumberFormatException ignore) {
            return Objects.equals(ip, cidr);
        }
    }

    private static int ipv42Int(String[] ips) {
        return Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
    }
}

