/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.Assert;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;

public class NumberedTestCase
extends Assert
implements Test {
    Method[] testMethods = new Method[0];
    protected static final String standardPrefix = "test##_";

    public NumberedTestCase() {
        try {
            Method[] methods = ((Object)((Object)this)).getClass().getMethods();
            TreeSet<Method> tm = new TreeSet<Method>(new MethodComparator());
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith("test")) continue;
                tm.add(methods[i]);
            }
            this.testMethods = new Method[tm.size()];
            Iterator orderedMethods = tm.iterator();
            int i = 0;
            while (orderedMethods.hasNext()) {
                this.testMethods[i] = (Method)orderedMethods.next();
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public int countTestCases() {
        return this.testMethods.length;
    }

    public void run(TestResult result) {
        try {
            this.setUp();
        }
        catch (Exception e) {
            Test test = new Test(){

                public int countTestCases() {
                    return 0;
                }

                public void run(TestResult result) {
                }

                public String toString() {
                    return NumberedTestCase.this.name() + ".setUp()";
                }
            };
            result.addError(test, (Throwable)e);
            return;
        }
        for (int i = 0; i < this.testMethods.length; ++i) {
            this.run(result, this.testMethods[i]);
        }
        try {
            this.tearDown();
        }
        catch (Exception e) {
            Test test = new Test(){

                public int countTestCases() {
                    return 0;
                }

                public void run(TestResult result) {
                }

                public String toString() {
                    return NumberedTestCase.this.name() + ".tearDown()";
                }
            };
            result.addError(test, (Throwable)e);
            return;
        }
    }

    protected void run(TestResult result, final Method testMethod) {
        Test test = this.createTest(testMethod);
        result.startTest(test);
        Protectable p = new Protectable(){

            public void protect() throws Throwable {
                NumberedTestCase.this.runTestMethod(testMethod);
            }
        };
        result.runProtected(test, p);
        result.endTest(test);
    }

    protected Test createTest(final Method testMethod) {
        Test test = new Test(){

            public int countTestCases() {
                return 1;
            }

            public void run(TestResult result) {
            }

            public String toString() {
                return NumberedTestCase.this.createTestName(testMethod);
            }
        };
        return test;
    }

    protected void runTestMethod(Method testMethod) throws Throwable {
        try {
            testMethod.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        return "";
    }

    protected String createTestName(Method testMethod) {
        return this.name() + NumberedTestCase.removePrefix(testMethod.getName());
    }

    protected static String removePrefix(String name) {
        return NumberedTestCase.removePrefix(standardPrefix, name);
    }

    protected static String removePrefix(String prefix, String name) {
        return name.substring(prefix.length());
    }

    class MethodComparator
    implements Comparator {
        MethodComparator() {
        }

        public int compare(Object o1, Object o2) {
            Method m1 = (Method)o1;
            Method m2 = (Method)o2;
            return m1.getName().compareTo(m2.getName());
        }

        public boolean eqauls(Object other) {
            return other instanceof MethodComparator;
        }
    }
}

