/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateful;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.rmi.PortableRemoteObject;
import org.openejb.test.stateful.BasicStatefulHome;
import org.openejb.test.stateful.BasicStatefulTestClient;

public class StatefulEjbObjectTests
extends BasicStatefulTestClient {
    public StatefulEjbObjectTests() {
        super("EJBObject.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulHome");
        this.ejbHome = (BasicStatefulHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicStatefulHome.class);
        this.ejbObject = this.ejbHome.create("Second Bean");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            StatefulEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            StatefulEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_isIdentical() {
        try {
            StatefulEjbObjectTests.assertTrue((String)"The EJBObjects are not equal", (boolean)this.ejbObject.isIdentical(this.ejbObject));
        }
        catch (Exception e) {
            StatefulEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            StatefulEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            StatefulEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_getPrimaryKey() {
        try {
            Object key = this.ejbObject.getPrimaryKey();
        }
        catch (RemoteException e) {
            StatefulEjbObjectTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            StatefulEjbObjectTests.fail((String)("A RuntimeException should have been thrown.  Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulEjbObjectTests.fail((String)"A RuntimeException should have been thrown.");
    }

    public void test05_remove() {
        try {
            this.ejbObject.remove();
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                StatefulEjbObjectTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception e) {
                StatefulEjbObjectTests.assertTrue((boolean)true);
                return;
            }
        }
        catch (Exception e) {
            StatefulEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

