/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.config;

import com.opensymphony.webwork.config.DefaultConfiguration;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    static Configuration configurationImpl;
    static Configuration defaultImpl;
    static Locale locale;
    private static final Log LOG;
    static /* synthetic */ Class class$com$opensymphony$webwork$config$Configuration;

    public static void setConfiguration(Configuration aConfig) throws IllegalStateException {
        configurationImpl = aConfig;
        locale = null;
    }

    public static Configuration getConfiguration() {
        return configurationImpl == null ? Configuration.getDefaultConfiguration() : configurationImpl;
    }

    public static Locale getLocale() {
        if (locale == null) {
            try {
                StringTokenizer localeTokens = new StringTokenizer(Configuration.getString("webwork.locale"), "_");
                String lang = null;
                String country = null;
                if (localeTokens.hasMoreTokens()) {
                    lang = localeTokens.nextToken();
                }
                if (localeTokens.hasMoreTokens()) {
                    country = localeTokens.nextToken();
                }
                locale = new Locale(lang, country);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Setting locale to the default locale");
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    public static boolean isSet(String aName) {
        return Configuration.getConfiguration().isSetImpl(aName);
    }

    public static String getString(String aName) throws IllegalArgumentException {
        String val = Configuration.get(aName).toString();
        return val;
    }

    public static Object get(String aName) throws IllegalArgumentException {
        Object val = Configuration.getConfiguration().getImpl(aName);
        return val;
    }

    public static Iterator list() {
        return Configuration.getConfiguration().listImpl();
    }

    public boolean isSetImpl(String aName) {
        return false;
    }

    public static void set(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        Configuration.getConfiguration().setImpl(aName, aValue);
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This configuration does not support updating a setting");
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        return null;
    }

    public Iterator listImpl() {
        throw new UnsupportedOperationException("This configuration does not support listing the settings");
    }

    private static Configuration getDefaultConfiguration() {
        if (defaultImpl == null) {
            defaultImpl = new DefaultConfiguration();
            try {
                String className = Configuration.getString("webwork.configuration");
                if (!className.equals(defaultImpl.getClass().getName())) {
                    try {
                        defaultImpl = (Configuration)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not instantiate configuration", (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultImpl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOG = LogFactory.getLog((Class)(class$com$opensymphony$webwork$config$Configuration == null ? (class$com$opensymphony$webwork$config$Configuration = Configuration.class$("com.opensymphony.webwork.config.Configuration")) : class$com$opensymphony$webwork$config$Configuration));
    }
}

