/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.config;

import com.opensymphony.webwork.config.Configuration;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;

public class PropertiesConfiguration
extends Configuration {
    Properties settings = new Properties();

    public PropertiesConfiguration(String aName) {
        URL settingsUrl = Thread.currentThread().getContextClassLoader().getResource(aName + ".properties");
        if (settingsUrl == null) {
            throw new IllegalStateException(aName + ".properties missing");
        }
        try {
            this.settings.load(settingsUrl.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + aName + ".properties:" + e);
        }
    }

    public void setImpl(String aName, Object aValue) {
        this.settings.put(aName, aValue);
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        Object setting = this.settings.get(aName);
        if (setting == null) {
            throw new IllegalArgumentException("No such setting:" + aName);
        }
        return setting;
    }

    public boolean isSetImpl(String aName) {
        return this.settings.get(aName) != null;
    }

    public Iterator listImpl() {
        return this.settings.keySet().iterator();
    }
}

