/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionMap
extends AbstractMap
implements Serializable {
    HttpServletRequest request;
    Set entries;

    public SessionMap(HttpServletRequest request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HttpSession session;
        HttpSession httpSession = session = this.request.getSession();
        synchronized (httpSession) {
            this.entries = null;
            session.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        HttpSession session;
        HttpSession httpSession = session = this.request.getSession();
        synchronized (httpSession) {
            if (this.entries == null) {
                this.entries = new HashSet();
                Enumeration enumeration = session.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    final String key = enumeration.nextElement().toString();
                    final Object value = session.getAttribute(key);
                    this.entries.add(new Map.Entry(){

                        public boolean equals(Object obj) {
                            Map.Entry entry = (Map.Entry)obj;
                            return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                        }

                        public int hashCode() {
                            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                        }

                        public Object getKey() {
                            return key;
                        }

                        public Object getValue() {
                            return value;
                        }

                        public Object setValue(Object obj) {
                            SessionMap.this.request.getSession().setAttribute(key.toString(), obj);
                            return value;
                        }
                    });
                }
            }
        }
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        HttpSession session;
        HttpSession httpSession = session = this.request.getSession();
        synchronized (httpSession) {
            return session.getAttribute(key.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        HttpSession session;
        HttpSession httpSession = session = this.request.getSession();
        synchronized (httpSession) {
            this.entries = null;
            session.setAttribute(key.toString(), value);
            return this.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        HttpSession session;
        HttpSession httpSession = session = this.request.getSession();
        synchronized (httpSession) {
            this.entries = null;
            Object value = this.get(key);
            session.removeAttribute(key.toString());
            return value;
        }
    }
}

