/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jasperreports;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.views.jasperreports.JasperReportConstants;
import com.opensymphony.webwork.views.jasperreports.OgnlValueStackDataSource;
import com.opensymphony.webwork.views.jasperreports.OgnlValueStackShadowMap;
import com.opensymphony.xwork.util.OgnlValueStack;
import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporter;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JasperExportManager;
import dori.jasper.engine.JasperFillManager;
import dori.jasper.engine.JasperManager;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.JasperReport;
import dori.jasper.engine.export.JRCsvExporter;
import dori.jasper.engine.export.JRHtmlExporter;
import dori.jasper.engine.export.JRHtmlExporterParameter;
import dori.jasper.engine.export.JRXlsExporter;
import dori.jasper.engine.export.JRXmlExporter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JasperReportViewServlet
extends HttpServlet
implements JasperReportConstants {
    protected static Log log = LogFactory.getLog((Class)(class$com$opensymphony$webwork$views$jasperreports$JasperReportViewServlet == null ? (class$com$opensymphony$webwork$views$jasperreports$JasperReportViewServlet = JasperReportViewServlet.class$("com.opensymphony.webwork.views.jasperreports.JasperReportViewServlet")) : class$com$opensymphony$webwork$views$jasperreports$JasperReportViewServlet));
    protected String IMAGES_URI = "/images/";
    static /* synthetic */ Class class$com$opensymphony$webwork$views$jasperreports$JasperReportViewServlet;

    public void init() throws ServletException {
        super.init();
        if (this.getServletConfig().getInitParameter("IMAGES_URI") != null) {
            this.IMAGES_URI = this.getServletConfig().getInitParameter("IMAGES_URI");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String imageName = request.getParameter("image");
        if (imageName != null) {
            Map imagesMap = (Map)request.getSession().getAttribute("IMAGES_MAP");
            if (imagesMap != null) {
                byte[] imageData = (byte[])imagesMap.get(imageName);
                try {
                    response.setContentLength(imageData.length);
                    ServletOutputStream ouputStream = response.getOutputStream();
                    ouputStream.write(imageData, 0, imageData.length);
                    ouputStream.flush();
                    ouputStream.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)ioe.toString());
                }
            }
        } else {
            OgnlValueStack stack = ServletActionContext.getContext().getValueStack();
            String dataSource = "" + request.getAttribute("dataSource");
            OgnlValueStackDataSource stackDataSource = new OgnlValueStackDataSource(stack, dataSource);
            String outputFormat = "" + request.getAttribute("format");
            if (outputFormat == null) {
                outputFormat = "PDF";
            }
            if (!"contype".equals(request.getHeader("User-Agent"))) {
                String systemId = this.getServletContext().getRealPath(request.getServletPath());
                OgnlValueStackShadowMap parameters = new OgnlValueStackShadowMap(stack);
                File directory = new File(systemId.substring(0, systemId.lastIndexOf(File.separator)));
                parameters.put("reportDirectory", directory);
                byte[] output = null;
                JasperPrint jasperPrint = null;
                try {
                    JasperReport jasperReport = JasperManager.loadReport((String)systemId);
                    jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)stackDataSource);
                }
                catch (JRException e) {
                    log.error((Object)("Error building report for uri " + systemId), (Throwable)e);
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
                try {
                    if (outputFormat.equals("PDF")) {
                        response.setContentType("application/pdf");
                        output = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
                    } else {
                        JRCsvExporter exporter = null;
                        if (outputFormat.equals("CSV")) {
                            response.setContentType("text/plain");
                            exporter = new JRCsvExporter();
                        } else if (outputFormat.equals("HTML")) {
                            response.setContentType("text/html");
                            HashMap imagesMap = new HashMap();
                            request.getSession().setAttribute("IMAGES_MAP", imagesMap);
                            exporter = new JRHtmlExporter();
                            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
                            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"*.jasper?image=");
                        } else if (outputFormat.equals("XLS")) {
                            response.setContentType("application/vnd.ms-excel");
                            exporter = new JRXlsExporter();
                        } else if (outputFormat.equals("XML")) {
                            response.setContentType("text/xml");
                            exporter = new JRXmlExporter();
                        } else {
                            throw new ServletException("Unknown report format: " + outputFormat);
                        }
                        output = this.exportReportToBytes(jasperPrint, (JRExporter)exporter);
                    }
                }
                catch (JRException e) {
                    String message = "Error producing " + outputFormat + " report for uri " + systemId;
                    log.error((Object)message, (Throwable)e);
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
                response.setContentLength(output.length);
                try {
                    if (log.isDebugEnabled()) {
                        // empty if block
                    }
                    ServletOutputStream ouputStream = response.getOutputStream();
                    ouputStream.write(output);
                    ouputStream.flush();
                    ouputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error writing report output", (Throwable)e);
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                response.setContentType("application/pdf");
                response.setContentLength(0);
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error writing report output", (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private byte[] exportReportToBytes(JasperPrint jasperPrint, JRExporter exporter) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        byte[] output = baos.toByteArray();
        return output;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

