/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.util;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UrlHelper {
    private static final String AMP = "&";

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params) {
        return UrlHelper.buildUrl(action, request, response, params, null, true, true);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult) {
        String result;
        StringBuffer link = new StringBuffer();
        boolean changedScheme = false;
        if (scheme != null && !scheme.equals(request.getScheme())) {
            changedScheme = true;
            link.append(scheme);
            link.append("://");
            link.append(request.getServerName());
            int port = request.getServerPort();
            if (!(scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443)) {
                link.append(":");
                link.append(port);
            }
        }
        if (action != null) {
            if (action.startsWith("/") && includeContext) {
                link.append(request.getContextPath());
            } else if (changedScheme) {
                String uri = request.getRequestURI();
                link.append(uri.substring(0, uri.lastIndexOf(47)));
            }
            link.append(action);
        } else {
            String requestURI = (String)request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (params != null && params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append("?");
            } else {
                link.append(AMP);
            }
            Iterator iterator = params.entrySet().iterator();
            String[] valueHolder = new String[1];
            while (iterator.hasNext()) {
                String[] values;
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String[]) {
                    values = (String[])value;
                } else {
                    valueHolder[0] = value.toString();
                    values = valueHolder;
                }
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != null) {
                        link.append(name);
                        link.append('=');
                        link.append(UrlHelper.translateAndEncode(values[i]));
                    }
                    if (i >= values.length - 1) continue;
                    link.append(AMP);
                }
                if (!iterator.hasNext()) continue;
                link.append(AMP);
            }
        }
        try {
            result = encodeResult ? response.encodeURL(link.toString()) : link.toString();
        }
        catch (Exception ex) {
            result = link.toString();
        }
        return result;
    }

    public static String translateAndEncode(String input) {
        OgnlValueStack valueStack = ServletActionContext.getContext().getValueStack();
        String output = TextParseUtil.translateVariables((String)input, (OgnlValueStack)valueStack);
        return URLEncoder.encode(output);
    }
}

