/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.webwork.views.freemarker.ScopesHashModel;
import com.opensymphony.webwork.views.freemarker.ValueStackModel;
import com.opensymphony.xwork.ActionInvocation;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FreemarkerResult
extends WebWorkResultSupport {
    protected ActionInvocation invocation;
    protected Configuration configuration;
    protected ObjectWrapper wrapper;
    protected String location;
    private String pContentType = "text/html";

    public void setContentType(String aContentType) {
        this.pContentType = aContentType;
    }

    public String getContentType() {
        return this.pContentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(String location, ActionInvocation invocation) throws IOException, TemplateException {
        TemplateModel model;
        this.location = location;
        this.invocation = invocation;
        this.configuration = this.getConfiguration();
        this.wrapper = this.getObjectWrapper();
        Template template = this.configuration.getTemplate(location, this.deduceLocale());
        if (this.preTemplateProcess(template, model = this.createModel())) {
            try {
                template.process((Object)model, this.getWriter());
            }
            finally {
                this.postTemplateProcess(template, model);
            }
        }
    }

    protected Configuration getConfiguration() throws TemplateException {
        return FreemarkerManager.getInstance().getConfigruation(ServletActionContext.getServletContext());
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.configuration.getObjectWrapper();
    }

    protected Writer getWriter() throws IOException {
        return new OutputStreamWriter((OutputStream)ServletActionContext.getResponse().getOutputStream());
    }

    protected TemplateModel createModel() throws TemplateModelException {
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ScopesHashModel model = FreemarkerManager.getInstance().buildScopesHashModel(servletContext, request, response, this.wrapper);
        FreemarkerManager.getInstance().populateContext(model, this.invocation.getStack(), this.invocation.getAction(), request, response);
        return new ValueStackModel(ServletActionContext.getContext().getValueStack(), (TemplateHashModel)model, this.wrapper);
    }

    protected Locale deduceLocale() {
        return this.configuration.getLocale();
    }

    protected void postTemplateProcess(Template template, TemplateModel data) throws IOException {
    }

    protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
        Object attrContentType = template.getCustomAttribute("content_type");
        if (attrContentType != null) {
            ServletActionContext.getResponse().setContentType(attrContentType.toString());
        } else {
            String encoding;
            String contentType = this.getContentType();
            if (contentType == null) {
                contentType = "text/html";
            }
            if ((encoding = template.getEncoding()) != null) {
                contentType = contentType + "; charset=" + encoding;
            }
            ServletActionContext.getResponse().setContentType(contentType);
        }
        return true;
    }
}

