/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.webwork.views.freemarker.ScopesHashModel;
import com.opensymphony.webwork.views.freemarker.ValueStackModel;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FreemarkerServlet
extends HttpServlet {
    protected Configuration configuration;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public void init() throws ServletException {
        try {
            this.configuration = this.createConfiguration();
        }
        catch (TemplateException e) {
            throw new ServletException("could not configure Freemarker", (Throwable)e);
        }
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.configuration.getObjectWrapper();
    }

    protected Configuration createConfiguration() throws TemplateException {
        return FreemarkerManager.getInstance().getConfigruation(this.getServletContext());
    }

    protected TemplateModel createModel(ObjectWrapper wrapper, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws TemplateModelException {
        ScopesHashModel model = FreemarkerManager.getInstance().buildScopesHashModel(servletContext, request, response, this.getObjectWrapper());
        Action action = null;
        if (ServletActionContext.getContext().getActionInvocation() != null) {
            action = ServletActionContext.getContext().getActionInvocation().getAction();
        }
        OgnlValueStack stack = ServletActionContext.getContext().getValueStack();
        FreemarkerManager.getInstance().populateContext(model, stack, action, request, response);
        return new ValueStackModel(stack, (TemplateHashModel)model, wrapper);
    }

    protected Locale deduceLocale(String templatePath, HttpServletRequest request, HttpServletResponse response) {
        return this.configuration.getLocale();
    }

    protected void postTemplateProcess(HttpServletRequest request, HttpServletResponse response, Template template, TemplateModel data) throws ServletException, IOException {
    }

    protected boolean preTemplateProcess(HttpServletRequest request, HttpServletResponse response, Template template, TemplateModel data) throws ServletException, IOException {
        return true;
    }

    protected String requestUrlToTemplatePath(HttpServletRequest request) {
        String includeServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (includeServletPath != null) {
            String includePathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            return includePathInfo == null ? includeServletPath : includePathInfo;
        }
        String path = request.getPathInfo();
        if (path != null) {
            return path;
        }
        path = request.getServletPath();
        if (path != null) {
            return path;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block9: {
            String path = this.requestUrlToTemplatePath(request);
            Template template = null;
            try {
                template = this.configuration.getTemplate(path, this.deduceLocale(path, request, response));
            }
            catch (FileNotFoundException e) {
                response.sendError(404);
                return;
            }
            Object attrContentType = template.getCustomAttribute("content_type");
            if (attrContentType != null) {
                response.setContentType(attrContentType.toString());
            } else {
                response.setContentType("text/html; charset=" + template.getEncoding());
            }
            ServletContext servletContext = this.getServletContext();
            try {
                TemplateModel model = this.createModel(this.getObjectWrapper(), servletContext, request, response);
                if (!this.preTemplateProcess(request, response, template, model)) break block9;
                try {
                    template.process((Object)model, (Writer)response.getWriter());
                }
                finally {
                    this.postTemplateProcess(request, response, template, model);
                }
            }
            catch (TemplateException te) {
                if (this.configuration.getTemplateExceptionHandler() == TemplateExceptionHandler.HTML_DEBUG_HANDLER || this.configuration.getTemplateExceptionHandler() == TemplateExceptionHandler.DEBUG_HANDLER) break block9;
                throw new ServletException((Throwable)te);
            }
        }
    }
}

