/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.reader;

import android.util.Xml;
import jadex.xml.TypeInfoPathManager;
import jadex.xml.reader.AReader;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.reader.IXMLReader;
import jadex.xml.reader.PullParserWrapper;
import jadex.xml.stax.XMLReporter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PullParserReader
extends AReader {
    private XmlPullParserFactory factory;
    private boolean bulklink;

    public PullParserReader() {
        this(false, null, false);
    }

    public PullParserReader(boolean validate, XMLReporter reporter, boolean bulklink) {
        this(validate, false, reporter, bulklink);
    }

    public PullParserReader(boolean validate, boolean coalescing, XMLReporter reporter, boolean bulklink) {
        super(bulklink, reporter);
        try {
            this.factory = XmlPullParserFactory.newInstance();
            this.factory.setNamespaceAware(true);
            this.factory.setValidating(validate);
            this.bulklink = bulklink;
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    public Object read(TypeInfoPathManager tipmanager, IObjectReaderHandler handler, InputStream input, ClassLoader classloader, Object callcontext) throws Exception {
        return this.read(tipmanager, handler, new InputStreamReader(input, "utf-8"), classloader, callcontext);
    }

    protected IXMLReader createXMLReader(InputStream input) {
        try {
            XmlPullParser parser = this.factory.newPullParser();
            parser.setInput(input, Xml.Encoding.UTF_8.name());
            return new PullParserWrapper(parser);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IXMLReader createXMLReader(Reader input) {
        try {
            XmlPullParser parser = this.factory.newPullParser();
            parser.setInput(input);
            return new PullParserWrapper(parser);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return null;
        }
    }
}

