/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.reader;

import jadex.xml.reader.IXMLReader;
import jadex.xml.stax.ILocation;
import jadex.xml.stax.Location;
import jadex.xml.stax.QName;
import jadex.xml.stax.XmlTag;
import jadex.xml.stax.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PullParserWrapper
implements IXMLReader {
    private static final Map<Integer, Integer> EVENT_TYPE_MAPPING = new HashMap<Integer, Integer>();
    protected InputStreamReader isreader;
    protected XmlPullParser parser;
    protected boolean hasnext;
    protected int inttype;
    protected LinkedList<XmlTag> tagstack = new LinkedList();
    protected XmlTag closedtag;
    Map<String, String> attrs;

    public PullParserWrapper(InputStream in) {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            this.parser = factory.newPullParser();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        try {
            this.isreader = new InputStreamReader(in, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try {
            this.parser.setInput((Reader)this.isreader);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        this.hasnext = true;
    }

    public PullParserWrapper(XmlPullParser parser) {
        this.parser = parser;
        this.hasnext = true;
    }

    public int getEventType() {
        Integer ret = EVENT_TYPE_MAPPING.get(this.inttype);
        return ret == null ? Integer.MIN_VALUE : ret;
    }

    public boolean hasNext() {
        return this.hasnext;
    }

    public int next() {
        try {
            this.inttype = this.parser.nextToken();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        if (this.inttype == 1) {
            this.hasnext = false;
        }
        if (this.inttype == 2) {
            this.tagstack.addFirst(new XmlTag(this.parser.getNamespace(), this.parser.getName()));
            if (this.parser.getAttributeCount() > 0) {
                this.attrs = new HashMap<String, String>(this.parser.getAttributeCount());
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    this.attrs.put(this.parser.getAttributeName(i), XmlUtil.unescapeString((String)this.parser.getAttributeValue(i)));
                }
            } else {
                this.attrs = null;
            }
        }
        if (this.inttype == 3) {
            this.closedtag = this.tagstack.removeFirst();
        }
        return this.getEventType();
    }

    public XmlTag getXmlTag() {
        return this.tagstack.peek();
    }

    public XmlTag getClosedTag() {
        return this.closedtag;
    }

    public LinkedList<XmlTag> getXmlTagStack() {
        return this.tagstack;
    }

    public Map<String, String> getAttributes() {
        return this.attrs;
    }

    public String getText() {
        return this.parser.getText();
    }

    public void close() {
        try {
            if (this.isreader != null) {
                this.isreader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ILocation getLocation() {
        return new Location(this.parser.getLineNumber(), this.parser.getColumnNumber(), 0, null, null);
    }

    public String getLocalName() {
        return this.parser.getName();
    }

    public int getAttributeCount() {
        return this.parser.getAttributeCount();
    }

    public String getAttributeLocalName(int i) {
        return this.parser.getAttributeName(i);
    }

    public String getAttributeValue(int i) {
        return this.parser.getAttributeValue(i);
    }

    public QName getName() {
        return new QName(this.parser.getNamespace(), this.parser.getName(), this.parser.getPrefix());
    }

    public String getAttributePrefix(int i) {
        return this.parser.getAttributePrefix(i);
    }

    public String getAttributeNamespace(int i) {
        return this.parser.getAttributeNamespace(i);
    }

    static {
        EVENT_TYPE_MAPPING.put(2, 1);
        EVENT_TYPE_MAPPING.put(3, 2);
        EVENT_TYPE_MAPPING.put(4, 4);
        EVENT_TYPE_MAPPING.put(5, 12);
        EVENT_TYPE_MAPPING.put(6, 4);
        EVENT_TYPE_MAPPING.put(9, 5);
    }
}

