/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.writer;

import jadex.commons.collection.Tree;
import jadex.commons.collection.TreeNode;
import jadex.xml.IContext;
import jadex.xml.IPreProcessor;
import jadex.xml.SXML;
import jadex.xml.StackElement;
import jadex.xml.TypeInfo;
import jadex.xml.stax.QName;
import jadex.xml.writer.AWriteContext;
import jadex.xml.writer.AWriter;
import jadex.xml.writer.IObjectWriterHandler;
import jadex.xml.writer.WriteContextAndroid;
import jadex.xml.writer.WriteObjectInfo;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class PullParserWriter
extends AWriter {
    public static final String NULL_NS_URI = "";
    protected static XmlPullParserFactory FACTORY;
    protected boolean genids;
    protected boolean indent;

    public PullParserWriter(boolean genIds, boolean indent) {
        this.genids = genIds;
        this.indent = indent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IObjectWriterHandler handler, Object object, String encoding, OutputStream out, ClassLoader classloader, Object context) throws Exception {
        XmlSerializer writer;
        XmlPullParserFactory xmlPullParserFactory = FACTORY;
        synchronized (xmlPullParserFactory) {
            writer = FACTORY.newSerializer();
            writer.setOutput(out, encoding);
        }
        writer.startDocument(encoding, Boolean.valueOf(false));
        writer.text(SXML.lf);
        WriteContextAndroid wc = new WriteContextAndroid(handler, writer, context, object, classloader);
        this.writeObject(wc, object, null);
        writer.endDocument();
    }

    private void writeObject(WriteContextAndroid wc, Object object, QName tag) throws Exception {
        int i;
        XmlSerializer writer = PullParserWriter.getWriter(wc);
        List stack = wc.getStack();
        if (object == null) {
            this.writeStartObject(writer, SXML.NULL, stack.size());
            this.writeEndObject(writer, stack.size());
            return;
        }
        TypeInfo typeinfo = wc.getHandler().getTypeInfo(object, this.getXMLPath(stack), (IContext)wc);
        QName[] path = new QName[]{};
        IPreProcessor[] preprocs = wc.getHandler().getPreProcessors(object, (Object)typeinfo);
        if (preprocs != null && preprocs.length > 0) {
            for (i = 0; i < preprocs.length; ++i) {
                object = preprocs[i].preProcess((IContext)wc, object);
            }
        }
        if ((tag == null || tag.getNamespaceURI().startsWith("typeinfo:")) && typeinfo != null) {
            tag = typeinfo.getXMLTag();
            if (typeinfo.getXMLInfo() != null) {
                path = typeinfo.getXMLInfo().getXMLPathElements();
                i = 0;
                while (i + 1 < path.length) {
                    this.writeStartObject(writer, path[i], stack.size());
                    stack.add(new StackElement(path[i], object));
                    writer.text(SXML.lf);
                    ++i;
                }
            }
        }
        if (tag == null) {
            tag = wc.getHandler().getTagName(object, (IContext)wc);
        }
        if (!NULL_NS_URI.equals(tag.getNamespaceURI()) && NULL_NS_URI.equals(tag.getPrefix())) {
            tag = wc.getHandler().getTagWithPrefix(tag, (IContext)wc);
        }
        if (this.genids && wc.getWrittenObjects().containsKey(object)) {
            this.writeStartObject(writer, tag, stack.size());
            writer.attribute(NULL_NS_URI, "__IDREF", (String)wc.getWrittenObjects().get(object));
            this.writeEndObject(writer, 0);
        } else {
            boolean subs;
            String content;
            WriteObjectInfo wi;
            String comment;
            if (wc.getWrittenObjects().containsKey(object)) {
                boolean rec = false;
                for (int i2 = 0; i2 < stack.size() && !rec; ++i2) {
                    if (!object.equals(((StackElement)stack.get(i2)).getObject())) continue;
                    throw new RuntimeException("Object structure contains cycles: Enable 'genids' mode for serialization.");
                }
            }
            if ((comment = (wi = wc.getHandler().getObjectWriteInfo(object, typeinfo, (IContext)wc)).getComment()) != null) {
                this.writeIndentation(writer, stack.size());
                writer.comment(comment);
                writer.text(SXML.lf);
            }
            this.writeStartObject(writer, tag, stack.size());
            int curid = wc.getId();
            StackElement topse = new StackElement(tag, object);
            stack.add(topse);
            wc.getWrittenObjects().put(object, NULL_NS_URI + curid);
            if (this.genids) {
                writer.attribute(NULL_NS_URI, "__ID", NULL_NS_URI + curid);
            }
            wc.setId(curid + 1);
            Map attrs = wi.getAttributes();
            if (attrs != null) {
                for (Object propname : attrs.keySet()) {
                    String value = (String)attrs.get(propname);
                    if (propname instanceof String) {
                        writer.attribute(NULL_NS_URI, (String)propname, value);
                        continue;
                    }
                    if (!(propname instanceof QName)) continue;
                    QName attrname = (QName)propname;
                    if (!NULL_NS_URI.equals(attrname.getNamespaceURI()) && NULL_NS_URI.equals(attrname.getPrefix())) {
                        attrname = wc.getHandler().getTagWithPrefix(tag, (IContext)wc);
                    }
                    String uri = attrname.getNamespaceURI();
                    String prefix = attrname.getPrefix();
                    String localname = attrname.getLocalPart();
                    if (!NULL_NS_URI.equals(uri)) {
                        if (!prefix.equals(writer.getPrefix(uri, false))) {
                            writer.setPrefix(prefix, uri);
                            writer.attribute(uri, localname, value);
                            continue;
                        }
                        writer.attribute(uri, localname, value);
                        continue;
                    }
                    writer.attribute(NULL_NS_URI, localname, value);
                }
            }
            if (wi.getContent() != null && (content = wi.getContent()) != null) {
                if ((content.indexOf("<") != -1 || content.indexOf(">") != -1 || content.indexOf("&") != -1) && content.indexOf("<![CDATA[") == -1) {
                    writer.cdsect(content);
                } else {
                    writer.text(content);
                }
            }
            boolean bl = subs = wi.getSubobjects() != null && !wi.getSubobjects().isEmpty();
            if (subs) {
                Tree subobs = wi.getSubobjects();
                writer.text(SXML.lf);
                this.writeSubobjects(wc, subobs.getRootNode(), typeinfo);
            }
            this.writeEndObject(writer, subs ? stack.size() - 1 : 0);
            stack.remove(stack.size() - 1);
            int i3 = 0;
            while (i3 + 1 < path.length) {
                this.writeEndObject(writer, stack.size() - 1);
                stack.remove(stack.size() - 1);
                ++i3;
            }
        }
    }

    protected void writeSubobjects(WriteContextAndroid wc, TreeNode node, TypeInfo typeinfo) throws Exception {
        XmlSerializer writer = PullParserWriter.getWriter(wc);
        List stack = wc.getStack();
        List children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TreeNode subnode = (TreeNode)children.get(i);
            Object tmp = subnode.getData();
            if (tmp instanceof QName) {
                QName subtag = (QName)tmp;
                this.writeStartObject(writer, subtag, stack.size());
                writer.text(SXML.lf);
                stack.add(new StackElement(subtag, null));
                this.writeSubobjects(wc, subnode, typeinfo);
                stack.remove(stack.size() - 1);
                this.writeEndObject(writer, stack.size());
                continue;
            }
            this.writeObject(wc, ((Object[])tmp)[1], (QName)((Object[])tmp)[0]);
        }
    }

    protected void writeStartObject(XmlSerializer writer, QName tag, int level) throws Exception {
        this.writeIndentation(writer, level);
        String uri = tag.getNamespaceURI();
        String prefix = tag.getPrefix();
        if (!NULL_NS_URI.equals(uri)) {
            if (!prefix.equals(writer.getPrefix(uri, false))) {
                writer.setPrefix(prefix, uri);
                writer.startTag(uri, tag.getLocalPart());
            } else {
                writer.startTag(uri, tag.getLocalPart());
            }
        } else {
            writer.startTag(NULL_NS_URI, tag.getLocalPart());
        }
    }

    protected void writeEndObject(XmlSerializer writer, int level) throws Exception {
        this.writeIndentation(writer, level);
        writer.endTag(writer.getNamespace(), writer.getName());
        writer.text(SXML.lf);
    }

    protected void writeIndentation(XmlSerializer writer, int level) throws Exception {
        if (this.indent) {
            for (int i = 0; i < level; ++i) {
                writer.text("\t");
            }
        }
    }

    protected QName[] getXMLPath(List stack) {
        QName[] ret = new QName[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            ret[i] = ((StackElement)stack.get(i)).getTag();
        }
        return ret;
    }

    public static XmlSerializer getWriter(AWriteContext context) {
        return (XmlSerializer)context.getWriter();
    }

    static {
        try {
            FACTORY = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
    }
}

