/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.eliza;

import jadex.base.Starter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.IService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.chat.ChatEvent;
import jadex.bridge.service.types.chat.IChatGuiService;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.commons.future.ThreadSuspendable;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;

@Agent
@RequiredServices(value={@RequiredService(name="chat", type=IChatGuiService.class, binding=@Binding(scope="platform"))})
public class EchoChatAgent {
    @Agent
    protected IInternalAccess agent;
    @AgentService
    protected IChatGuiService chat;

    @AgentCreated
    public void start() {
        this.chat.status("idle", null, new IComponentIdentifier[0]);
        final IComponentIdentifier self = ((IService)this.chat).getServiceIdentifier().getProviderId();
        this.chat.subscribeToEvents().addResultListener((IResultListener)new IntermediateDefaultResultListener<ChatEvent>(){

            public void intermediateResultAvailable(ChatEvent event) {
                if ("message".equals(event.getType()) && !self.equals(event.getComponentIdentifier()) && event.isPrivateMessage()) {
                    String s = (String)event.getValue();
                    if ((s = s.trim()).length() > 0) {
                        EchoChatAgent.this.chat.message(s, new IComponentIdentifier[]{event.getComponentIdentifier()}, true);
                    }
                }
            }

            public void exceptionOccurred(Exception exception) {
            }
        });
    }

    public static void main(String[] args) {
        ThreadSuspendable sus = new ThreadSuspendable();
        IExternalAccess pl = (IExternalAccess)Starter.createPlatform((String[])new String[]{"-gui", "false", "-autoshutdown", "false"}).get();
        IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getService((IExternalAccess)pl, IComponentManagementService.class, (String)"platform").get();
        for (int i = 0; i < 10000; ++i) {
            System.out.print(".");
            if (i % 100 == 0) {
                System.out.println("\n " + i + ": ");
            }
            IComponentIdentifier cid = (IComponentIdentifier)cms.createComponent(EchoChatAgent.class.getName() + ".class", null).getFirstResult();
            try {
                cms.destroyComponent(cid).get();
                continue;
            }
            catch (Exception e) {
                System.out.println("Ex: " + e.getMessage());
            }
        }
        System.out.println("fini");
    }
}

