/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.eliza;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.nonfunctional.annotation.NameValue;
import jadex.bridge.service.IService;
import jadex.bridge.service.types.chat.ChatEvent;
import jadex.bridge.service.types.chat.IChatGuiService;
import jadex.commons.LazyResource;
import jadex.commons.Tuple2;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.Component;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.Configuration;
import jadex.micro.annotation.Configurations;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.eliza.ElizaParse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Agent
@ComponentTypes(value={@ComponentType(name="chat", filename="jadex/platform/service/chat/ChatAgent.class")})
@Configurations(value={@Configuration(name="default", components={@Component(type="chat", arguments={@NameValue(name="nosave", value="true")}, configuration="user")})})
@RequiredServices(value={@RequiredService(name="chat", type=IChatGuiService.class)})
public class ElizaAgent {
    @Agent
    protected IInternalAccess agent;
    @AgentService
    protected IChatGuiService chat;
    protected Map<IComponentIdentifier, Tuple2<ElizaParse, Long>> conversations;

    @AgentCreated
    public void start() {
        this.conversations = new HashMap<IComponentIdentifier, Tuple2<ElizaParse, Long>>();
        this.chat.setNickName("Eliza");
        this.chat.status("idle", null, new IComponentIdentifier[0]);
        try {
            this.chat.setImage(new LazyResource(ElizaAgent.class, "images/eliza.png").getData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        final IComponentIdentifier self = ((IService)this.chat).getServiceIdentifier().getProviderId();
        this.chat.subscribeToEvents().addResultListener((IResultListener)new IntermediateDefaultResultListener<ChatEvent>(){

            public void intermediateResultAvailable(ChatEvent event) {
                if ("message".equals(event.getType()) && !self.equals(event.getComponentIdentifier())) {
                    String s = (String)event.getValue();
                    s = s.trim();
                    if (event.isPrivateMessage() && s.length() > 0) {
                        Tuple2<ElizaParse, Long> tup = ElizaAgent.this.conversations.get(event.getComponentIdentifier());
                        ElizaParse eliza = tup == null ? new ElizaParse() : (ElizaParse)tup.getFirstEntity();
                        ElizaAgent.this.conversations.put(event.getComponentIdentifier(), (Tuple2<ElizaParse, Long>)new Tuple2((Object)eliza, (Object)System.currentTimeMillis()));
                        eliza.handleLine(s);
                        ElizaAgent.this.writeToLog(s, event.getComponentIdentifier());
                        while (!eliza.msg.isEmpty()) {
                            ElizaAgent.this.chat.message(eliza.msg.elementAt(0), new IComponentIdentifier[]{event.getComponentIdentifier()}, true);
                            ElizaAgent.this.writeToLog("> " + eliza.msg.elementAt(0), event.getComponentIdentifier());
                            eliza.msg.removeElementAt(0);
                        }
                    } else if (s.toLowerCase().indexOf("eliza") != -1) {
                        ElizaAgent.this.writeToLog(s, event.getComponentIdentifier());
                        ElizaAgent.this.chat.message("Hi! I'm the famous Eliza program. Please tell me your problem in private.", new IComponentIdentifier[]{event.getComponentIdentifier()}, true);
                        ElizaAgent.this.writeToLog("> Hi! I'm the famous Eliza program. Please tell me your problem in private.", event.getComponentIdentifier());
                    }
                }
            }

            public void exceptionOccurred(Exception exception) {
            }
        });
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(60000L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                Iterator<IComponentIdentifier> it = ElizaAgent.this.conversations.keySet().iterator();
                while (it.hasNext()) {
                    Tuple2<ElizaParse, Long> tup = ElizaAgent.this.conversations.get(it.next());
                    if ((Long)tup.getSecondEntity() + 30000L >= System.currentTimeMillis()) continue;
                    it.remove();
                }
                return IFuture.DONE;
            }
        });
    }

    protected void writeToLog(String text, IComponentIdentifier partner) {
        try {
            File dir = new File(System.getProperty("user.home"), ".eliza");
            File f = new File(dir, partner.getName() + ".txt");
            f.getParentFile().mkdirs();
            PrintStream os = new PrintStream(new FileOutputStream(f, true));
            os.println(text);
            os.flush();
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

