/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.gameoflife;

import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.SimplePropertyObject;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.ISpaceProcess;
import jadex.extension.envsupport.environment.space2d.Grid2D;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Int;
import jadex.extension.envsupport.math.Vector2Int;
import java.util.HashMap;
import java.util.Set;

public class GameOfLifeProcess
extends SimplePropertyObject
implements ISpaceProcess {
    protected double lasttick;

    public void start(IClockService clock, IEnvironmentSpace space) {
        this.lasttick = clock.getTick();
        Space2D grid = (Space2D)space;
        int sizex = grid.getAreaSize().getXAsInteger();
        int sizey = grid.getAreaSize().getYAsInteger();
        for (int x = 0; x < sizex; ++x) {
            for (int y = 0; y < sizey; ++y) {
                HashMap<String, Boolean> props = new HashMap<String, Boolean>();
                Boolean alive = Math.random() > 0.7;
                props.put("alive", alive);
                props.put("position", (Boolean)new Vector2Int(x, y));
                grid.createSpaceObject("cell", props, null);
            }
        }
    }

    public void shutdown(IEnvironmentSpace space) {
    }

    public void execute(IClockService clock, IEnvironmentSpace space) {
        long rate;
        Grid2D grid = (Grid2D)space;
        long l = rate = this.getProperty("rate") != null ? ((Number)this.getProperty("rate")).longValue() : 3L;
        if (this.lasttick + (double)rate < clock.getTick()) {
            ISpaceObject cell;
            int y;
            int x;
            this.lasttick += (double)rate;
            int sizex = grid.getAreaSize().getXAsInteger();
            int sizey = grid.getAreaSize().getYAsInteger();
            boolean[][] alive = new boolean[sizex][sizey];
            for (x = 0; x < sizex; ++x) {
                for (y = 0; y < sizey; ++y) {
                    cell = (ISpaceObject)grid.getSpaceObjectsByGridPosition((IVector2)new Vector2Int(x, y), (Object)"cell").iterator().next();
                    Set neighbors = grid.getNearObjects((IVector2)new Vector2Int(x, y), (IVector1)new Vector1Int(1), "cell");
                    neighbors.remove(cell);
                    int nbcnt = 0;
                    for (ISpaceObject neighbor : neighbors) {
                        if (!((Boolean)neighbor.getProperty("alive")).booleanValue()) continue;
                        ++nbcnt;
                    }
                    if (!((Boolean)cell.getProperty("alive")).booleanValue()) {
                        if (nbcnt != 3) continue;
                        alive[x][y] = true;
                        continue;
                    }
                    if (nbcnt != 2 && nbcnt != 3) continue;
                    alive[x][y] = true;
                }
            }
            for (x = 0; x < sizex; ++x) {
                for (y = 0; y < sizey; ++y) {
                    cell = (ISpaceObject)grid.getSpaceObjectsByGridPosition((IVector2)new Vector2Int(x, y), (Object)"cell").iterator().next();
                    cell.setProperty("alive", (Object)(alive[x][y] ? Boolean.TRUE : Boolean.FALSE));
                }
            }
        }
    }
}

