/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.heatbugs;

import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.SimplePropertyObject;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.ISpaceProcess;
import jadex.extension.envsupport.environment.space2d.Grid2D;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Int;
import jadex.extension.envsupport.math.Vector2Int;
import java.util.HashMap;
import java.util.Set;

public class DiffusionProcess
extends SimplePropertyObject
implements ISpaceProcess {
    protected double lasttick;

    public void start(IClockService clock, IEnvironmentSpace space) {
        this.lasttick = clock.getTick();
        boolean random_init = this.getProperty("random_init") != null ? (Boolean)this.getProperty("random_init") : false;
        Space2D grid = (Space2D)space;
        int sizex = grid.getAreaSize().getXAsInteger();
        int sizey = grid.getAreaSize().getYAsInteger();
        for (int x = 0; x < sizex; ++x) {
            for (int y = 0; y < sizey; ++y) {
                HashMap<String, Double> props = new HashMap<String, Double>();
                if (random_init) {
                    double heat = Math.random() * 100.0;
                    props.put("heat", heat);
                }
                props.put("position", (Double)new Vector2Int(x, y));
                grid.createSpaceObject("patch", props, null);
            }
        }
    }

    public void shutdown(IEnvironmentSpace space) {
    }

    public void execute(IClockService clock, IEnvironmentSpace space) {
        double cooling;
        Grid2D grid = (Grid2D)space;
        long rate = this.getProperty("rate") != null ? ((Number)this.getProperty("rate")).longValue() : 1L;
        double diffusion = this.getProperty("diffusion_rate") != null ? ((Number)this.getProperty("diffusion_rate")).doubleValue() : 0.1;
        double d = cooling = this.getProperty("evaporation_rate") != null ? ((Number)this.getProperty("evaporation_rate")).doubleValue() : 0.1;
        if (this.lasttick + (double)rate < clock.getTick()) {
            ISpaceObject patch;
            int y;
            int x;
            this.lasttick += (double)rate;
            int sizex = grid.getAreaSize().getXAsInteger();
            int sizey = grid.getAreaSize().getYAsInteger();
            double[][] adds = new double[sizex][sizey];
            for (x = 0; x < sizex; ++x) {
                for (y = 0; y < sizey; ++y) {
                    patch = (ISpaceObject)grid.getSpaceObjectsByGridPosition((IVector2)new Vector2Int(x, y), (Object)"patch").iterator().next();
                    Set neighbors = grid.getNearObjects((IVector2)new Vector2Int(x, y), (IVector1)new Vector1Int(1), "patch");
                    neighbors.remove(patch);
                    double myoldheat = (Double)patch.getProperty("heat");
                    double mysub = myoldheat * diffusion;
                    double otheradd = mysub / (double)neighbors.size();
                    double[] dArray = adds[x];
                    int n = y;
                    dArray[n] = dArray[n] - mysub;
                    for (ISpaceObject neighbor : neighbors) {
                        IVector2 otherpos = (IVector2)neighbor.getProperty("position");
                        double[] dArray2 = adds[otherpos.getXAsInteger()];
                        int n2 = otherpos.getYAsInteger();
                        dArray2[n2] = dArray2[n2] + otheradd;
                    }
                }
            }
            for (x = 0; x < sizex; ++x) {
                for (y = 0; y < sizey; ++y) {
                    patch = (ISpaceObject)grid.getSpaceObjectsByGridPosition((IVector2)new Vector2Int(x, y), (Object)"patch").iterator().next();
                    double oldheat = (Double)patch.getProperty("heat");
                    double cool = oldheat * cooling;
                    double newheat = Math.max(0.0, oldheat + adds[x][y] - cool);
                    patch.setProperty("heat", (Object)newheat);
                }
            }
        }
    }
}

