/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.heatbugs;

import jadex.application.EnvironmentService;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.Grid2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Int;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

@Agent
public class HeatbugAgent {
    @Agent
    protected IInternalAccess agent;
    protected double randomchance;
    protected double ideal_temp;
    protected double mytemp;
    protected double unhappiness;

    @AgentBody
    public IFuture<Void> executeBody() {
        Future ret = new Future();
        EnvironmentService.getSpace((IInternalAccess)this.agent, (String)"mygc2dspace").addResultListener((IResultListener)new ExceptionDelegationResultListener<Object, Void>(ret){

            public void customResultAvailable(Object result) {
                final Grid2D grid = (Grid2D)result;
                ISpaceObject avatar = grid.getAvatar(HeatbugAgent.this.agent.getComponentDescription());
                HeatbugAgent.this.randomchance = ((Number)avatar.getProperty("random_move_chance")).doubleValue();
                HeatbugAgent.this.ideal_temp = ((Number)avatar.getProperty("ideal_temp")).doubleValue();
                IComponentStep<Void> com = new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ISpaceObject avatar = grid.getAvatar(HeatbugAgent.this.agent.getComponentDescription());
                        IVector2 mypos = (IVector2)avatar.getProperty("position");
                        Collection coll = grid.getSpaceObjectsByGridPosition(mypos, (Object)"patch");
                        if (coll != null) {
                            ISpaceObject patch = (ISpaceObject)coll.iterator().next();
                            HeatbugAgent.this.mytemp = ((Number)patch.getProperty("heat")).doubleValue();
                            HeatbugAgent.this.unhappiness = ((Number)avatar.getProperty("unhappiness")).doubleValue();
                            if (HeatbugAgent.this.unhappiness > 0.0) {
                                Set tmp = grid.getNearObjects((IVector2)avatar.getProperty("position"), (IVector1)new Vector1Int(1), "patch");
                                tmp.remove(patch);
                                ISpaceObject[] neighbors = tmp.toArray(new ISpaceObject[tmp.size()]);
                                IVector2 target = null;
                                if (Math.random() < HeatbugAgent.this.randomchance) {
                                    IVector2 choicepos;
                                    int choice = (int)(Math.random() * (double)neighbors.length);
                                    target = choicepos = (IVector2)neighbors[choice].getProperty("position");
                                } else if (HeatbugAgent.this.mytemp > HeatbugAgent.this.ideal_temp) {
                                    ISpaceObject min = patch;
                                    double minheat = HeatbugAgent.this.mytemp;
                                    for (int i = 0; i < neighbors.length; ++i) {
                                        double heat = ((Number)neighbors[i].getProperty("heat")).doubleValue();
                                        if (!(heat < minheat)) continue;
                                        min = neighbors[i];
                                        minheat = heat;
                                    }
                                    target = (IVector2)min.getProperty("position");
                                } else {
                                    ISpaceObject max = patch;
                                    double maxheat = HeatbugAgent.this.mytemp;
                                    for (int i = 0; i < neighbors.length; ++i) {
                                        double heat = ((Number)neighbors[i].getProperty("heat")).doubleValue();
                                        if (!(heat > maxheat)) continue;
                                        max = neighbors[i];
                                        maxheat = heat;
                                    }
                                    target = (IVector2)max.getProperty("position");
                                }
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("object_id", avatar.getId());
                                params.put("position", target);
                                grid.performSpaceAction("move", params, null);
                            }
                        }
                        ((IExecutionFeature)HeatbugAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForTick((IComponentStep)this);
                        return IFuture.DONE;
                    }

                    public String toString() {
                        return "heatbug.body()";
                    }
                };
                ((IExecutionFeature)HeatbugAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForTick((IComponentStep)com);
            }
        });
        return ret;
    }
}

