/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.helpline;

import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.annotation.GuiClass;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.SReflect;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.helpline.HelplinePanel;
import jadex.micro.examples.helpline.HelplineService;
import jadex.micro.examples.helpline.HelplineViewerPanel;
import jadex.micro.examples.helpline.IHelpline;
import jadex.micro.examples.helpline.InformationEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.SwingUtilities;

@Description(value="This agent offers a helpline for getting information about missing persons.")
@RequiredServices(value={@RequiredService(name="clockservice", type=IClockService.class, binding=@Binding(scope="platform")), @RequiredService(name="remotehelplineservices", type=IHelpline.class, multiple=true, binding=@Binding(scope="global")), @RequiredService(name="localhelplineservices", type=IHelpline.class, multiple=true, binding=@Binding(scope="platform"))})
@ProvidedServices(value={@ProvidedService(type=IHelpline.class, implementation=@Implementation(value=HelplineService.class))})
@GuiClass(value=HelplineViewerPanel.class)
@Agent
public class HelplineAgent {
    @Agent
    protected IInternalAccess agent;
    protected MultiCollection<String, InformationEntry> infos;

    @AgentCreated
    public IFuture<Void> agentCreated() {
        this.infos = new MultiCollection();
        Object ini = ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("infos");
        if (ini != null && SReflect.isIterable(ini)) {
            Iterator it = SReflect.getIterator(ini);
            while (it.hasNext()) {
                InformationEntry ie = (InformationEntry)it.next();
                this.infos.add((Object)ie.getName(), (Object)ie);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelplinePanel.createHelplineGui(HelplineAgent.this.agent.getExternalAccess());
            }
        });
        return IFuture.DONE;
    }

    public void addInformation(final String name, final String info) {
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("clockservice");
        fut.addResultListener((IResultListener)new DefaultResultListener<IClockService>(){

            public void resultAvailable(IClockService cs) {
                HelplineAgent.this.infos.add((Object)name, (Object)new InformationEntry(name, info, cs.getTime()));
            }
        });
    }

    public Collection<InformationEntry> getInformation(String name) {
        Collection ret = this.infos.get((Object)name);
        return ret != null ? ret : Collections.EMPTY_LIST;
    }

    public IInternalAccess getAgent() {
        return this.agent;
    }
}

