/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.helpline;

import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IMonitoringComponentFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.monitoring.IMonitoringEvent;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.future.CollectionResultListener;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.commons.future.IntermediateFuture;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingIntermediateResultListener;
import jadex.commons.gui.jtable.DateTimeRenderer;
import jadex.micro.examples.helpline.IHelpline;
import jadex.micro.examples.helpline.InfoTableModel;
import jadex.micro.examples.helpline.InformationEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;

public class HelplinePanel
extends JPanel {
    protected IExternalAccess agent;

    public HelplinePanel(IExternalAccess agent) {
        this.agent = agent;
        this.setLayout(new BorderLayout());
        JPanel phelp = new JPanel(new BorderLayout());
        JPanel pget = new JPanel(new GridBagLayout());
        pget.setBorder(new TitledBorder(new EtchedBorder(), "Search Options"));
        final JTextField tfname = new JTextField("Lennie Lost");
        final JButton bsearchinfo = new JButton("Search");
        final JCheckBox cbremoteinfo = new JCheckBox("Remote");
        pget.add((Component)new JLabel("Person's name"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(1, 2, 1, 2), 0, 0));
        pget.add((Component)tfname, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 2, 1, 2), 0, 0));
        pget.add((Component)cbremoteinfo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(1, 2, 1, 2), 0, 0));
        pget.add((Component)bsearchinfo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(1, 2, 1, 2), 0, 0));
        final ArrayList infolist = new ArrayList();
        final InfoTableModel infomodel = new InfoTableModel(infolist);
        bsearchinfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                bsearchinfo.setEnabled(false);
                HelplinePanel.this.getInformation(tfname.getText(), cbremoteinfo.isSelected()).addResultListener((IResultListener)new SwingDefaultResultListener(){

                    public void customResultAvailable(Object result) {
                        infolist.clear();
                        if (result != null) {
                            infolist.addAll((Collection)result);
                        }
                        infomodel.fireTableDataChanged();
                        bsearchinfo.setEnabled(true);
                    }

                    public void customExceptionOccurred(Exception exception) {
                        super.customExceptionOccurred(exception);
                        bsearchinfo.setEnabled(true);
                    }
                });
            }
        });
        phelp.add((Component)pget, "North");
        JPanel infopanel = new JPanel(new BorderLayout());
        infopanel.setBorder(new TitledBorder(new EtchedBorder(), "Person Information"));
        JTable infotable = new JTable(infomodel);
        infotable.setPreferredScrollableViewportSize(new Dimension(600, 120));
        infotable.setSelectionMode(0);
        infotable.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTimeRenderer());
        infopanel.add("Center", new JScrollPane(infotable));
        phelp.add((Component)infopanel, "Center");
        JPanel padd = new JPanel(new BorderLayout());
        padd.setBorder(new TitledBorder(new EtchedBorder(1), "Add Information Entry "));
        JPanel pss = new JPanel(new GridBagLayout());
        final JComboBox cbselser = new JComboBox();
        final JCheckBox cbremoteser = new JCheckBox("Remote");
        JButton bsearchser = new JButton("Search");
        JLabel selsl = new JLabel("Select service");
        pss.add((Component)selsl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(1, 2, 1, 2), 0, 0));
        pss.add(cbselser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 2, 1, 2), 0, 0));
        pss.add((Component)cbremoteser, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(1, 2, 1, 2), 0, 0));
        pss.add((Component)bsearchser, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(1, 2, 1, 2), 0, 0));
        bsearchser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelplinePanel.this.refreshServicesCombo(cbselser, cbremoteser.isSelected());
            }
        });
        padd.add((Component)pss, "North");
        JPanel pinfoentry = new JPanel(new GridBagLayout());
        JLabel lname = new JLabel("Name");
        lname.setPreferredSize(selsl.getPreferredSize());
        pinfoentry.add((Component)lname, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(1, 2, 1, 2), 0, 0));
        final JTextField tfpname = new JTextField("Lennie Lost");
        pinfoentry.add((Component)tfpname, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 2, 1, 2), 0, 0));
        pinfoentry.add((Component)new JLabel("Information"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(1, 12, 1, 2), 0, 0));
        final JTextField tfpinfo = new JTextField(8);
        pinfoentry.add((Component)tfpinfo, new GridBagConstraints(3, 0, 1, 1, 3.0, 0.0, 13, 1, new Insets(1, 2, 1, 2), 0, 0));
        final JButton badd = new JButton("Add");
        badd.setPreferredSize(bsearchser.getPreferredSize());
        badd.setEnabled(false);
        pinfoentry.add((Component)badd, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(1, 2, 1, 2), 0, 0));
        badd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHelpline hl = (IHelpline)cbselser.getSelectedItem();
                if (hl != null) {
                    hl.addInformation(tfpname.getText(), tfpinfo.getText());
                }
            }
        });
        cbselser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHelpline hl = (IHelpline)cbselser.getSelectedItem();
                if (hl != null) {
                    badd.setEnabled(true);
                } else {
                    badd.setEnabled(false);
                }
            }
        });
        padd.add((Component)pinfoentry, "Center");
        phelp.add((Component)padd, "South");
        this.add((Component)phelp, "Center");
        this.refreshServicesCombo(cbselser, cbremoteser.isSelected());
    }

    protected void refreshServicesCombo(final JComboBox selcb, boolean remote) {
        this.agent.scheduleStep((IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                ((IRequiredServicesFeature)ia.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("localhelplineservices").addResultListener((IResultListener)new SwingDefaultResultListener(HelplinePanel.this){

                    public void customResultAvailable(Object result) {
                        Collection newservices = (Collection)result;
                        selcb.removeAllItems();
                        if (newservices != null) {
                            Iterator it = newservices.iterator();
                            while (it.hasNext()) {
                                selcb.addItem(it.next());
                            }
                        }
                    }
                });
                return IFuture.DONE;
            }
        });
    }

    public IIntermediateFuture<InformationEntry> getInformation(final String name, final boolean remote) {
        final IntermediateFuture ret = new IntermediateFuture();
        IIntermediateFuture fut = (IIntermediateFuture)this.agent.scheduleStep((IComponentStep)new IComponentStep<Collection<IHelpline>>(){

            public IIntermediateFuture<IHelpline> execute(IInternalAccess ia) {
                ITerminableIntermediateFuture ret = remote ? ((IRequiredServicesFeature)ia.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("remotehelplineservices") : ((IRequiredServicesFeature)ia.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("localhelplineservices");
                return ret;
            }
        });
        fut.addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                if (result != null) {
                    Collection coll = (Collection)result;
                    CollectionResultListener crl = new CollectionResultListener(coll.size(), true, (IResultListener)new DefaultResultListener(){

                        public void resultAvailable(Object result) {
                            if (result != null) {
                                Collection tmp = (Collection)result;
                                Iterator it = tmp.iterator();
                                ArrayList all = new ArrayList();
                                while (it.hasNext()) {
                                    Collection part = (Collection)it.next();
                                    for (Object next : part) {
                                        if (!(next instanceof InformationEntry) || all.contains(next)) continue;
                                        all.add(next);
                                    }
                                }
                                Collections.sort(all);
                                ret.setResult(all);
                            } else {
                                ret.setResult(null);
                            }
                        }
                    });
                    for (IHelpline hl : coll) {
                        IIntermediateFuture<InformationEntry> res = hl.getInformation(name);
                        res.addResultListener((IResultListener)crl);
                    }
                }
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public static void createHelplineGui(final IExternalAccess agent) {
        final JFrame f = new JFrame();
        f.add(new HelplinePanel(agent));
        f.pack();
        f.setLocation(SGUI.calculateMiddlePosition((Window)f));
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                agent.killComponent();
            }
        });
        IResultListener<Void> dislis = new IResultListener<Void>(){

            public void exceptionOccurred(Exception exception) {
                f.dispose();
            }

            public void resultAvailable(Void result) {
            }
        };
        agent.scheduleStep((IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                ((IMonitoringComponentFeature)ia.getComponentFeature(IMonitoringComponentFeature.class)).subscribeToEvents(IMonitoringEvent.TERMINATION_FILTER, false, IMonitoringService.PublishEventLevel.COARSE).addResultListener((IResultListener)new SwingIntermediateResultListener((IIntermediateResultListener)new IntermediateDefaultResultListener<IMonitoringEvent>(){

                    public void intermediateResultAvailable(IMonitoringEvent result) {
                        f.dispose();
                    }
                }));
                return IFuture.DONE;
            }
        }).addResultListener((IResultListener)dislis);
    }
}

