/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.nonfunctional.annotation.NameValue;
import jadex.commons.Boolean3;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Configuration;
import jadex.micro.annotation.Configurations;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.examples.mandelbrot.CalculateService;
import jadex.micro.examples.mandelbrot.ICalculateService;
import jadex.micro.examples.mandelbrot.IProgressService;
import jadex.micro.examples.mandelbrot.ProgressService;

@Description(value="Agent offering a calculate service.")
@ProvidedServices(value={@ProvidedService(type=ICalculateService.class, implementation=@Implementation(value=CalculateService.class)), @ProvidedService(type=IProgressService.class, implementation=@Implementation(value=ProgressService.class, proxytype="direct"))})
@Arguments(value={@Argument(name="delay", description="Agent kills itself when no job arrives in the delay interval.", clazz=Long.class, defaultvalue="new Long(1000)")})
@Configurations(value={@Configuration(name="default"), @Configuration(name="long lived", arguments={@NameValue(name="delay", value="-1")})})
@Agent(synchronous=Boolean3.FALSE)
public class CalculateAgent {
    @Agent
    protected IInternalAccess agent;
    protected boolean hadjob;
    protected Object taskid;
    protected int progress;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        final long delay = ((Number)((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("delay")).longValue();
        IComponentStep<Void> step = new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                if (!CalculateAgent.this.isHadJob()) {
                    ret.setResult(null);
                }
                CalculateAgent.this.setHadJob(false);
                ((IExecutionFeature)CalculateAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(delay, (IComponentStep)this);
                return IFuture.DONE;
            }
        };
        if (delay > 0L) {
            ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(delay, (IComponentStep)step);
        }
        return ret;
    }

    public void setHadJob(boolean hadjob) {
        this.hadjob = hadjob;
    }

    public boolean isHadJob() {
        return this.hadjob;
    }

    public Object getTaskId() {
        return this.taskid;
    }

    public void setTaskId(Object taskid) {
        this.taskid = taskid;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }
}

