/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.micro.examples.mandelbrot.AreaData;
import jadex.micro.examples.mandelbrot.CalculateAgent;
import jadex.micro.examples.mandelbrot.ICalculateService;

@Service
public class CalculateService
implements ICalculateService {
    @ServiceComponent
    protected CalculateAgent agent;

    @Override
    public IFuture<AreaData> calculateArea(AreaData data) {
        this.agent.setHadJob(true);
        this.agent.setTaskId(data.getId());
        Future ret = new Future();
        double stepx = (data.getXEnd() - data.getXStart()) / (double)data.getSizeX();
        double stepy = (data.getYEnd() - data.getYStart()) / (double)data.getSizeY();
        short[][] res = new short[data.getSizeX()][data.getSizeY()];
        int xend = data.getSizeX() - 1;
        int ystart = 0;
        int yend = data.getSizeY() - 1;
        boolean allin = true;
        boolean justfill = false;
        short fillcol = -2;
        boolean usejustfill = data.getAlgorithm().isOptimizationAllowed() && (data.getXStart() < 2.0 && data.getXStart() > -2.0 || data.getYStart() < 2.0 && data.getYStart() > -2.0 || data.getXEnd() < 2.0 && data.getXEnd() > -2.0 || data.getYEnd() < 2.0 && data.getYEnd() > -2.0);
        int size = data.getSizeX() * data.getSizeY();
        int cnt = 0;
        for (int xstart = 0; xstart <= xend; ++xstart) {
            int yi;
            int xi;
            for (xi = xstart; xi <= xend; ++xi) {
                short s = res[xi][ystart] = justfill ? fillcol : data.getAlgorithm().determineColor(data.getXStart() + (double)xi * stepx, data.getYStart() + (double)ystart * stepy, data.getMax());
                if (!justfill && xi == xstart) {
                    fillcol = res[xi][ystart];
                }
                if (allin && res[xi][ystart] != fillcol) {
                    allin = false;
                }
                this.agent.setProgress(++cnt * 100 / size);
            }
            if (++ystart > yend) break;
            for (yi = ystart; yi <= yend; ++yi) {
                short s = res[xend][yi] = justfill ? fillcol : data.getAlgorithm().determineColor(data.getXStart() + (double)xend * stepx, data.getYStart() + (double)yi * stepy, data.getMax());
                if (allin && res[xend][yi] != fillcol) {
                    allin = false;
                }
                this.agent.setProgress(++cnt * 100 / size);
            }
            if (xstart > --xend) break;
            for (xi = xend; xi >= xstart; --xi) {
                short s = res[xi][yend] = justfill ? fillcol : data.getAlgorithm().determineColor(data.getXStart() + (double)xi * stepx, data.getYStart() + (double)yend * stepy, data.getMax());
                if (allin && res[xi][yend] != fillcol) {
                    allin = false;
                }
                this.agent.setProgress(++cnt * 100 / size);
            }
            if (ystart > --yend) break;
            for (yi = yend; yi >= ystart; --yi) {
                short s = res[xstart][yi] = justfill ? fillcol : data.getAlgorithm().determineColor(data.getXStart() + (double)xstart * stepx, data.getYStart() + (double)yi * stepy, data.getMax());
                if (allin && res[xstart][yi] != fillcol) {
                    allin = false;
                }
                this.agent.setProgress(++cnt * 100 / size);
            }
            if (!allin || !usejustfill) continue;
            justfill = true;
            allin = false;
        }
        this.agent.setTaskId(null);
        this.agent.setProgress(0);
        data.setData(res);
        ret.setResult((Object)data);
        return ret;
    }
}

